/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.XmlElementUtil;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StyleCopParser
extends IssueParser {
    private static final long serialVersionUID = 7846052338159003458L;

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        Document document = readerFactory.readDocument();
        NodeList mainNode = document.getElementsByTagName("SourceAnalysisViolations");
        if (mainNode.getLength() == 0) {
            mainNode = document.getElementsByTagName("StyleCopViolations");
        }
        Element rootElement = (Element)mainNode.item(0);
        return this.parseViolations(XmlElementUtil.getNamedChildElements(rootElement, "Violation"));
    }

    private Report parseViolations(List<Element> elements) {
        Report report = new Report();
        for (Element element : elements) {
            IssueBuilder builder = new IssueBuilder().setFileName(this.getString(element, "Source")).setLineStart(this.getLineNumber(element)).setCategory(this.getCategory(element)).setType(this.getString(element, "Rule")).setMessage(element.getTextContent()).setSeverity(Severity.WARNING_NORMAL);
            report.add(builder.build());
        }
        return report;
    }

    private String getCategory(Element element) {
        String ruleNameSpace = this.getString(element, "RuleNamespace");
        int i = ruleNameSpace.lastIndexOf(46);
        if (i == -1) {
            return this.getString(element, "RuleId");
        }
        return ruleNameSpace.substring(i + 1);
    }

    private String getString(Element element, String name) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        return "";
    }

    private int getLineNumber(Element violation) {
        if (violation.hasAttribute("LineNumber")) {
            return Integer.parseInt(violation.getAttribute("LineNumber"));
        }
        return 0;
    }
}

