/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.XmlElementUtil;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TaglistParser
extends IssueParser {
    private static final long serialVersionUID = 1L;

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            IssueBuilder issueBuilder = new IssueBuilder();
            Report report = new Report();
            Document document = readerFactory.readDocument();
            NodeList tags = (NodeList)xPath.evaluate("/report/tags/tag", document, XPathConstants.NODESET);
            for (Element tag : XmlElementUtil.nodeListToList(tags)) {
                String category = xPath.evaluate("@name", tag);
                issueBuilder.setCategory(category);
                NodeList files = (NodeList)xPath.evaluate("files/file", tag, XPathConstants.NODESET);
                for (Element file : XmlElementUtil.nodeListToList(files)) {
                    issueBuilder.setFileName(xPath.evaluate("@name", file));
                    NodeList comments = (NodeList)xPath.evaluate("comments/comment", file, XPathConstants.NODESET);
                    for (Element comment : XmlElementUtil.nodeListToList(comments)) {
                        issueBuilder.setLineStart(xPath.evaluate("lineNumber", comment));
                        issueBuilder.setMessage(xPath.evaluate("comment", comment));
                        report.add(issueBuilder.build());
                    }
                }
            }
            return report;
        }
        catch (XPathExpressionException e) {
            throw new ParsingException(e);
        }
    }
}

