/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;

public class TaskingVxCompilerParser
extends RegexpLineParser {
    private static final long serialVersionUID = -5225265084645449716L;
    private static final String TASKING_VX_COMPILER_WARNING_PATTERN = "^.*? (I|W|E|F)(\\d+): (?:\\[\"(.*?)\" (\\d+)\\/(\\d+)\\] )?(.*)$";

    public TaskingVxCompilerParser() {
        super(TASKING_VX_COMPILER_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String category;
        Severity priority;
        String type;
        switch (type = matcher.group(1)) {
            case "E": {
                priority = Severity.WARNING_HIGH;
                category = "ERROR";
                break;
            }
            case "F": {
                priority = Severity.WARNING_HIGH;
                category = "License issue";
                break;
            }
            case "I": {
                priority = Severity.WARNING_LOW;
                category = "Info";
                break;
            }
            default: {
                priority = Severity.WARNING_NORMAL;
                category = "Warning";
            }
        }
        return builder.setFileName(matcher.group(3)).setLineStart(matcher.group(4)).setCategory(category).setMessage(matcher.group(6)).setSeverity(priority).buildOptional();
    }
}

