/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class TiCcsParser
extends RegexpLineParser {
    private static final long serialVersionUID = -8253481365175984661L;
    private static final String TI_CCS_WARNING_PATTERN = "^((\"(.*)\",\\s*)(line\\s*(\\d+)(\\s*\\(.*\\))?:)?\\s*)?(WARNING|ERROR|remark|warning|(fatal\\s*)?error)(!\\s*at line\\s(\\d+))?\\s*([^:]*)\\s*:\\s*(.*)$";

    public TiCcsParser() {
        super(TI_CCS_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String lineNumber = matcher.group(5);
        if (StringUtils.isBlank((CharSequence)lineNumber)) {
            lineNumber = matcher.group(10);
        }
        return builder.setFileName(matcher.group(3)).setLineStart(lineNumber).setCategory(matcher.group(11)).setMessage(matcher.group(12)).setSeverity(this.mapPriority(matcher)).buildOptional();
    }

    private Severity mapPriority(Matcher matcher) {
        if (this.isOfType(matcher, "remark")) {
            return Severity.WARNING_LOW;
        }
        if (this.isOfType(matcher, "warning")) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_HIGH;
    }

    private boolean isOfType(Matcher matcher, String type) {
        return StringUtils.containsIgnoreCase((CharSequence)matcher.group(7), (CharSequence)type);
    }
}

