/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.violations;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;

public abstract class AbstractViolationAdapter
extends IssueParser {
    private static final long serialVersionUID = 7203311857999721045L;

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingCanceledException, ParsingException {
        try {
            ViolationsParser parser = this.createParser();
            List violations = parser.parseReportOutput(readerFactory.readString());
            return this.convertToReport(violations);
        }
        catch (Exception exception) {
            throw new ParsingException(exception);
        }
    }

    protected abstract ViolationsParser createParser();

    private Report convertToReport(List<Violation> violations) {
        Report report = new Report();
        for (Violation violation : violations) {
            if (!this.isValid(violation)) continue;
            report.add(this.convertToIssue(violation));
        }
        return report;
    }

    protected boolean isValid(Violation violation) {
        return true;
    }

    private Issue convertToIssue(Violation violation) {
        IssueBuilder builder = new IssueBuilder();
        builder.setSeverity(this.convertSeverity(violation.getSeverity(), violation)).setFileName(violation.getFile()).setMessage(violation.getMessage()).setLineStart(violation.getStartLine()).setLineEnd(violation.getEndLine()).setColumnStart(violation.getColumn()).setType(violation.getRule()).setCategory(violation.getCategory());
        this.extractAdditionalProperties(builder, violation);
        return builder.build();
    }

    protected void extractAdditionalProperties(IssueBuilder builder, Violation violation) {
    }

    protected Severity convertSeverity(SEVERITY severity, Violation violation) {
        if (severity == SEVERITY.ERROR) {
            return Severity.WARNING_HIGH;
        }
        if (severity == SEVERITY.WARN) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }
}

