/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.StringUtils;

public class PathUtil {
    private static final String BACK_SLASH = "\\";
    private static final String SLASH = "/";

    public String toString(Path path) throws IOException {
        return this.normalize(path.toAbsolutePath().normalize().toRealPath(new LinkOption[0]).toString());
    }

    public String getAbsolutePath(String path) {
        try {
            return this.getAbsolutePath(Paths.get(path, new String[0]));
        }
        catch (InvalidPathException ignored) {
            return this.normalize(path);
        }
    }

    public String getAbsolutePath(Path path) {
        try {
            return this.normalize(this.toString(path));
        }
        catch (IOException | InvalidPathException ignored) {
            return this.normalize(path.toString());
        }
    }

    private String normalize(String fileName) {
        return fileName.replace(BACK_SLASH, SLASH);
    }

    public String createAbsolutePath(@CheckForNull String directory, String fileName) {
        if (this.isAbsolute(fileName) || StringUtils.isBlank((CharSequence)directory)) {
            return this.normalize(fileName);
        }
        String normalizedDirectory = this.normalize(directory);
        if (normalizedDirectory.endsWith(SLASH)) {
            return normalizedDirectory + fileName;
        }
        return normalizedDirectory + SLASH + fileName;
    }

    private boolean isAbsolute(String fileName) {
        try {
            return Paths.get(fileName, new String[0]).isAbsolute();
        }
        catch (InvalidPathException ignored) {
            return false;
        }
    }
}

