/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import edu.hm.hafner.util.Ensure;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class TreeString
implements Serializable {
    private static final long serialVersionUID = 3621959682117480904L;
    @CheckForNull
    private TreeString parent;
    private char[] label;

    TreeString() {
        this(null, "");
    }

    TreeString(@CheckForNull TreeString parent, String label) {
        Ensure.that(parent == null || !label.isEmpty()).isTrue("if there's a parent '%s', label '%s' can't be empty", parent, label);
        this.parent = parent;
        this.label = label.toCharArray();
    }

    String getLabel() {
        return new String(this.label);
    }

    TreeString split(String prefix) {
        assert (this.getLabel().startsWith(prefix));
        char[] suffix = new char[this.label.length - prefix.length()];
        System.arraycopy(this.label, prefix.length(), suffix, 0, suffix.length);
        TreeString middle = new TreeString(this.parent, prefix);
        this.label = suffix;
        this.parent = middle;
        return middle;
    }

    private int depth() {
        int i = 0;
        TreeString p = this;
        while (p != null) {
            ++i;
            p = p.parent;
        }
        return i;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs.getClass() == TreeString.class && ((TreeString)rhs).getLabel().equals(this.getLabel());
    }

    public int hashCode() {
        int h = this.parent == null ? 0 : this.parent.hashCode();
        for (char character : this.label) {
            h = 31 * h + character;
        }
        assert (this.toString().hashCode() == h);
        return h;
    }

    public String toString() {
        char[][] tokens = new char[this.depth()][];
        int i = tokens.length;
        int sz = 0;
        TreeString p = this;
        while (p != null) {
            tokens[--i] = p.label;
            sz += p.label.length;
            p = p.parent;
        }
        StringBuilder buf = new StringBuilder(sz);
        for (char[] token : tokens) {
            buf.append(token);
        }
        return buf.toString();
    }

    void dedup(Map<String, char[]> table) {
        String l = this.getLabel();
        char[] v = table.get(l);
        if (v == null) {
            table.put(l, this.label);
        } else {
            this.label = v;
        }
    }

    public boolean isBlank() {
        return StringUtils.isBlank((CharSequence)this.toString());
    }

    public static TreeString valueOf(String string) {
        return new TreeString(null, string);
    }
}

