/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.FullTextFingerprint;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.VisibleForTesting;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class FingerprintGenerator {
    public void run(FullTextFingerprint algorithm, Report report, Charset charset) {
        int errorCount = 0;
        ArrayList<String> errors = new ArrayList<String>();
        for (Issue issue : report) {
            if (issue.hasFingerprint()) continue;
            try {
                String digest = algorithm.compute(issue.getFileName(), issue.getLineStart(), charset);
                issue.setFingerprint(digest);
            }
            catch (IOException | InvalidPathException exception) {
                issue.setFingerprint(FingerprintGenerator.createDefaultFingerprint(issue));
                if (errorCount < 5) {
                    if (exception.getCause() instanceof MalformedInputException) {
                        errors.add(String.format("- '%s', provided encoding '%s' seems to be wrong", issue.getFileName(), charset));
                    } else {
                        errors.add(String.format("- '%s', IO exception has been thrown: %s", issue.getFileName(), exception));
                    }
                } else if (errorCount == 5) {
                    errors.add("  ... skipped logging of additional file errors ...");
                }
                ++errorCount;
            }
        }
        if (errorCount > 0) {
            report.logError("Can't create fingerprints for %d files:", errorCount);
            errors.forEach(x$0 -> report.logError((String)x$0, new Object[0]));
        }
    }

    @VisibleForTesting
    static String createDefaultFingerprint(Issue issue) {
        HashCodeBuilder builder = new HashCodeBuilder();
        return String.format("FALLBACK-%x", builder.append((Object)issue.getBaseName()).append((Object)issue.getType()).append((Object)issue.getCategory()).append((Object)issue.getSeverity()).append((Object)issue.getOrigin()).append(issue.getLineStart()).build());
    }
}

