/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.util.VisibleForTesting;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Locale;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;

public class FullTextFingerprint {
    private static final int LINES_LOOK_AHEAD = 3;
    private static final int LINE_RANGE_BUFFER_SIZE = 1000;
    private final MessageDigest digest;
    private final FileSystem fileSystem;

    public FullTextFingerprint() {
        this(new FileSystem());
    }

    @VisibleForTesting
    FullTextFingerprint(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public String compute(String fileName, int line, Charset charset) throws IOException {
        try (Stream<String> lines = this.fileSystem.readLinesFromFile(fileName, charset);){
            String string = this.createFingerprint(line, lines, charset);
            return string;
        }
    }

    @VisibleForTesting
    String getFallbackFingerprint(String fileName) {
        return String.format("%x", fileName.hashCode());
    }

    @VisibleForTesting
    String createFingerprint(int line, Stream<String> lines, Charset charset) {
        String context = this.extractContext(line, lines.iterator());
        lines.close();
        this.digest.update(context.getBytes(charset));
        return DatatypeConverter.printHexBinary((byte[])this.digest.digest()).toUpperCase(Locale.ENGLISH);
    }

    @VisibleForTesting
    String extractContext(int affectedLine, Iterator<String> lines) {
        int line;
        if (affectedLine < 0) {
            return "";
        }
        int start = this.computeStartLine(affectedLine);
        StringBuilder context = new StringBuilder(1000);
        for (line = 1; lines.hasNext() && line < start - 3; ++line) {
            lines.next();
        }
        while (lines.hasNext() && line <= start + 3) {
            context.append(lines.next());
            ++line;
        }
        return context.toString();
    }

    private int computeStartLine(int affectedLine) {
        if (affectedLine == 0) {
            return 4;
        }
        return affectedLine;
    }

    @VisibleForTesting
    static class FileSystem {
        FileSystem() {
        }

        @MustBeClosed
        Stream<String> readLinesFromFile(String fileName, Charset charset) throws IOException, InvalidPathException {
            return Files.lines(Paths.get(fileName, new String[0]), charset);
        }
    }
}

