/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.LineRangeList;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.TreeString;
import edu.hm.hafner.util.TreeStringBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class Issue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String UNDEFINED = "-";
    private String category;
    private String type;
    private final Severity severity;
    private final TreeString message;
    private final int lineStart;
    private final int lineEnd;
    private final int columnStart;
    private final int columnEnd;
    private final LineRangeList lineRanges;
    private final UUID id;
    private final TreeString description;
    @CheckForNull
    private final Serializable additionalProperties;
    private String reference;
    private String origin;
    private String moduleName;
    private TreeString packageName;
    private TreeString fileName;
    private String fingerprint;

    public static String getPropertyValueAsString(Issue issue, String propertyName) {
        try {
            return PropertyUtils.getProperty((Object)issue, (String)propertyName).toString();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            return propertyName;
        }
    }

    public static Function<Issue, String> getPropertyValueGetter(String propertyName) {
        return issue -> Issue.getPropertyValueAsString(issue, propertyName);
    }

    public static Predicate<Issue> byPackageName(String packageName) {
        return issue -> issue.getPackageName().equals(packageName);
    }

    public static Predicate<Issue> byModuleName(String moduleName) {
        return issue -> issue.getModuleName().equals(moduleName);
    }

    public static Predicate<Issue> byFileName(String fileName) {
        return issue -> issue.getFileName().equals(fileName);
    }

    public static Predicate<Issue> bySeverity(Severity severity) {
        return issue -> issue.getSeverity().equals(severity);
    }

    public static Predicate<Issue> byCategory(String category) {
        return issue -> issue.getCategory().equals(category);
    }

    public static Predicate<Issue> byOrigin(String origin) {
        return issue -> issue.getOrigin().equals(origin);
    }

    public static Predicate<Issue> byType(String type) {
        return issue -> issue.getType().equals(type);
    }

    protected Issue(Issue copy) {
        this(copy.getFileName(), copy.getLineStart(), copy.getLineEnd(), copy.getColumnStart(), copy.getColumnEnd(), copy.getLineRanges(), copy.getCategory(), copy.getType(), copy.getPackageName(), copy.getModuleName(), copy.getSeverity(), copy.getMessage(), copy.getDescription(), copy.getOrigin(), copy.getReference(), copy.getFingerprint(), copy.getAdditionalProperties(), copy.getId());
    }

    protected Issue(@CheckForNull String fileName, int lineStart, int lineEnd, int columnStart, int columnEnd, @CheckForNull LineRangeList lineRanges, @CheckForNull String category, @CheckForNull String type, @CheckForNull String packageName, @CheckForNull String moduleName, @CheckForNull Severity severity, @CheckForNull String message, @CheckForNull String description, @CheckForNull String origin, @CheckForNull String reference, @CheckForNull String fingerprint, @CheckForNull Serializable additionalProperties) {
        this(fileName, lineStart, lineEnd, columnStart, columnEnd, lineRanges, category, type, packageName, moduleName, severity, message, description, origin, reference, fingerprint, additionalProperties, UUID.randomUUID());
    }

    protected Issue(@CheckForNull String fileName, int lineStart, int lineEnd, int columnStart, int columnEnd, @CheckForNull LineRangeList lineRanges, @CheckForNull String category, @CheckForNull String type, @CheckForNull String packageName, @CheckForNull String moduleName, @CheckForNull Severity severity, @CheckForNull String message, @CheckForNull String description, @CheckForNull String origin, @CheckForNull String reference, @CheckForNull String fingerprint, @CheckForNull Serializable additionalProperties, UUID id) {
        int providedColumnEnd;
        int providedLineEnd;
        TreeStringBuilder builder = new TreeStringBuilder();
        this.fileName = builder.intern(this.defaultString(this.normalizeFileName(fileName)));
        int providedLineStart = this.defaultInteger(lineStart);
        int n = providedLineEnd = this.defaultInteger(lineEnd) == 0 ? providedLineStart : this.defaultInteger(lineEnd);
        if (providedLineStart == 0) {
            this.lineStart = providedLineEnd;
            this.lineEnd = providedLineEnd;
        } else {
            this.lineStart = Math.min(providedLineStart, providedLineEnd);
            this.lineEnd = Math.max(providedLineStart, providedLineEnd);
        }
        int providedColumnStart = this.defaultInteger(columnStart);
        int n2 = providedColumnEnd = this.defaultInteger(columnEnd) == 0 ? providedColumnStart : this.defaultInteger(columnEnd);
        if (providedColumnStart == 0) {
            this.columnStart = providedColumnEnd;
            this.columnEnd = providedColumnEnd;
        } else {
            this.columnStart = Math.min(providedColumnStart, providedColumnEnd);
            this.columnEnd = Math.max(providedColumnStart, providedColumnEnd);
        }
        this.lineRanges = new LineRangeList();
        if (lineRanges != null) {
            this.lineRanges.addAll(lineRanges);
        }
        this.category = StringUtils.defaultString((String)category).intern();
        this.type = this.defaultString(type);
        this.packageName = builder.intern(this.defaultString(packageName));
        this.moduleName = this.defaultString(moduleName);
        this.severity = (Severity)ObjectUtils.defaultIfNull((Object)severity, (Object)Severity.WARNING_NORMAL);
        this.message = builder.intern(StringUtils.stripToEmpty((String)message));
        this.description = builder.intern(StringUtils.stripToEmpty((String)description));
        this.origin = this.stripToEmpty(origin);
        this.reference = this.stripToEmpty(reference);
        this.fingerprint = this.defaultString(fingerprint);
        this.additionalProperties = additionalProperties;
        this.id = id;
    }

    protected Object readResolve() {
        this.category = this.category.intern();
        this.type = this.type.intern();
        this.moduleName = this.moduleName.intern();
        this.origin = this.origin.intern();
        this.reference = this.reference.intern();
        return this;
    }

    private String normalizeFileName(@CheckForNull String platformFileName) {
        return StringUtils.replace((String)StringUtils.strip((String)platformFileName), (String)"\\", (String)"/");
    }

    private int defaultInteger(int integer) {
        return integer < 0 ? 0 : integer;
    }

    private String defaultString(@CheckForNull String string) {
        return ((String)StringUtils.defaultIfEmpty((CharSequence)string, (CharSequence)UNDEFINED)).intern();
    }

    private String stripToEmpty(@CheckForNull String string) {
        return StringUtils.stripToEmpty((String)string).intern();
    }

    public UUID getId() {
        return this.id;
    }

    public String getFileName() {
        return this.fileName.toString();
    }

    public String getBaseName() {
        try {
            Path baseName = Paths.get(this.getFileName(), new String[0]).getFileName();
            if (baseName == null) {
                return this.getFileName();
            }
            return baseName.toString();
        }
        catch (InvalidPathException e) {
            return this.getFileName();
        }
    }

    public void setFileName(@CheckForNull String fileName) {
        this.fileName = TreeString.valueOf(StringUtils.stripToEmpty((String)fileName));
    }

    public String getCategory() {
        return this.category;
    }

    public String getType() {
        return this.type;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message.toString();
    }

    public String getDescription() {
        return this.description.toString();
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public int getLineEnd() {
        return this.lineEnd;
    }

    public LineRangeList getLineRanges() {
        return new LineRangeList(this.lineRanges);
    }

    public int getColumnStart() {
        return this.columnStart;
    }

    public int getColumnEnd() {
        return this.columnEnd;
    }

    public String getPackageName() {
        return this.packageName.toString();
    }

    public void setPackageName(@CheckForNull String packageName) {
        this.packageName = TreeString.valueOf(StringUtils.stripToEmpty((String)packageName));
    }

    public boolean hasPackageName() {
        return !UNDEFINED.equals(this.getPackageName());
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(@CheckForNull String moduleName) {
        this.moduleName = this.stripToEmpty(moduleName);
    }

    public boolean hasModuleName() {
        return !UNDEFINED.equals(this.getModuleName());
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        Ensure.that(origin).isNotBlank("Issue origin '%s' must be not blank (%s)", this.id, this.toString());
        this.origin = origin.intern();
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(@CheckForNull String reference) {
        this.reference = this.stripToEmpty(reference);
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(@CheckForNull String fingerprint) {
        this.fingerprint = StringUtils.stripToEmpty((String)fingerprint);
    }

    public boolean hasFingerprint() {
        return !UNDEFINED.equals(this.fingerprint);
    }

    @CheckForNull
    public Serializable getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        if (this.lineStart != issue.lineStart) {
            return false;
        }
        if (this.lineEnd != issue.lineEnd) {
            return false;
        }
        if (this.columnStart != issue.columnStart) {
            return false;
        }
        if (this.columnEnd != issue.columnEnd) {
            return false;
        }
        if (!this.category.equals(issue.category)) {
            return false;
        }
        if (!this.type.equals(issue.type)) {
            return false;
        }
        if (!this.severity.equals(issue.severity)) {
            return false;
        }
        if (!this.message.equals(issue.message)) {
            return false;
        }
        if (!this.lineRanges.equals(issue.lineRanges)) {
            return false;
        }
        if (!this.description.equals(issue.description)) {
            return false;
        }
        if (this.additionalProperties != null ? !this.additionalProperties.equals(issue.additionalProperties) : issue.additionalProperties != null) {
            return false;
        }
        if (!this.origin.equals(issue.origin)) {
            return false;
        }
        if (!this.moduleName.equals(issue.moduleName)) {
            return false;
        }
        if (!this.packageName.equals(issue.packageName)) {
            return false;
        }
        return this.fileName.equals(issue.fileName);
    }

    public int hashCode() {
        int result = this.category.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.severity.hashCode();
        result = 31 * result + this.message.hashCode();
        result = 31 * result + this.lineStart;
        result = 31 * result + this.lineEnd;
        result = 31 * result + this.columnStart;
        result = 31 * result + this.columnEnd;
        result = 31 * result + this.lineRanges.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + (this.additionalProperties != null ? this.additionalProperties.hashCode() : 0);
        result = 31 * result + this.origin.hashCode();
        result = 31 * result + this.moduleName.hashCode();
        result = 31 * result + this.packageName.hashCode();
        result = 31 * result + this.fileName.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s(%d,%d): %s: %s: %s", this.fileName, this.lineStart, this.columnStart, this.type, this.category, this.message);
    }
}

