/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.AbstractPackageDetector;
import edu.hm.hafner.analysis.PackageDetectors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

class JavaPackageDetector
extends AbstractPackageDetector {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("^\\s*package\\s*([a-z]+(\\.[a-zA-Z_][a-zA-Z0-9_]*)*)\\s*;.*");

    JavaPackageDetector() {
        this(new PackageDetectors.FileSystem());
    }

    JavaPackageDetector(PackageDetectors.FileSystem fileSystem) {
        super(fileSystem);
    }

    @Override
    public String detectPackageName(Stream<String> lines) {
        return lines.map(PACKAGE_PATTERN::matcher).filter(Matcher::matches).findFirst().map(matcher -> matcher.group(1)).orElse("-");
    }

    @Override
    public boolean accepts(String fileName) {
        return fileName.endsWith(".java");
    }
}

