/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlElementUtil {
    private XmlElementUtil() {
    }

    public static List<Element> getNamedChildElements(Element parent, String name) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (parent != null) {
            for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
                elements.add((Element)child);
            }
        }
        return elements;
    }

    @CheckForNull
    public static Element getFirstElementByTagName(Element parent, String tagName) {
        List<Element> foundElements = XmlElementUtil.getNamedChildElements(parent, tagName);
        if (foundElements.size() > 0) {
            return foundElements.get(0);
        }
        return null;
    }
}

