/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.FastRegexpLineParser;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class AntJavacParser
extends FastRegexpLineParser {
    private static final long serialVersionUID = 1737791073711198075L;
    private static final String ANT_JAVAC_WARNING_PATTERN = "^(?:.*\\[.*\\])?\\s*\\s*(.*java):(\\d*):\\s*(?:warning|\u8b66\u544a)\\s*:\\s*(?:\\[(\\w*)\\])?\\s*(.*)$|^\\s*\\[.*\\]\\s*warning.*\\]\\s*(.*\"(.*)\".*)$|^(.*class)\\s*:\\s*warning\\s*:\\s*(.*)$";

    public AntJavacParser() {
        super(ANT_JAVAC_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("warning") || line.contains("\u8b66\u544a");
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        if (StringUtils.isNotBlank((CharSequence)matcher.group(7))) {
            return builder.setFileName(matcher.group(7)).setLineStart(0).setCategory("").setMessage(matcher.group(8)).build();
        }
        if (StringUtils.isBlank((CharSequence)matcher.group(5))) {
            return builder.setFileName(matcher.group(1)).setLineStart(this.parseInt(matcher.group(2))).setCategory(this.guessCategoryIfEmpty(matcher.group(3), matcher.group(4))).setMessage(matcher.group(4)).build();
        }
        return builder.setFileName(matcher.group(6)).setLineStart(0).setCategory("Path").setMessage(matcher.group(5)).build();
    }
}

