/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpDocumentParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class DoxygenParser
extends RegexpDocumentParser {
    private static final long serialVersionUID = -6770174143703245309L;
    private static final String DOXYGEN_WARNING_PATTERN = "^(?:.*\\[.*\\])?\\s*(?:(?:((?:[/.]|[A-Za-z]:).+?):(-?\\d+):\\s*([Ww]arning|[Ee]rror)|<.+>:-?\\d+(?::\\s*([Ww]arning|[Ee]rror))?): (.+(?:\\n(?!\\s*(?:[Nn]otice|[Ww]arning|[Ee]rror): )[^/<\\n][^:\\n][^/\\n].+)*)|\\s*([Nn]otice|[Ww]arning|[Ee]rror): (.+))$";
    private static final int FILE_NAME_GROUP = 1;
    private static final int FILE_LINE_GROUP = 2;
    private static final int FILE_TYPE_GROUP = 3;
    private static final int FUNC_TYPE_GROUP = 4;
    private static final int LOCAL_MESSAGE_GROUP = 5;
    private static final int GLOBAL_TYPE_GROUP = 6;
    private static final int GLOBAL_MESSAGE_GROUP = 7;

    public DoxygenParser() {
        super(DOXYGEN_WARNING_PATTERN, true);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        Severity priority;
        String message;
        String fileName = "";
        int lineNumber = 0;
        if (StringUtils.isNotBlank((CharSequence)matcher.group(5))) {
            message = matcher.group(5);
            if (StringUtils.isNotBlank((CharSequence)matcher.group(1))) {
                fileName = matcher.group(1);
                lineNumber = this.parseInt(matcher.group(2));
                priority = this.parsePriority(matcher.group(3));
            } else {
                priority = this.parsePriority(matcher.group(4));
            }
        } else if (StringUtils.isNotBlank((CharSequence)matcher.group(7))) {
            message = matcher.group(7);
            priority = this.parsePriority(matcher.group(6));
        } else {
            message = "Unknown doxygen error.";
            priority = Severity.WARNING_HIGH;
        }
        return builder.setFileName(fileName).setLineStart(lineNumber).setMessage(message).setSeverity(priority).build();
    }

    private Severity parsePriority(String warningTypeString) {
        if (StringUtils.equalsIgnoreCase((CharSequence)warningTypeString, (CharSequence)"notice")) {
            return Severity.WARNING_LOW;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)warningTypeString, (CharSequence)"warning")) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_HIGH;
    }
}

