/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpDocumentParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.VisibleForTesting;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class EclipseParser
extends RegexpDocumentParser {
    private static final long serialVersionUID = 425883472788422955L;
    @VisibleForTesting
    public static final String ANT_ECLIPSE_WARNING_PATTERN = "\\[?(WARNING|ERROR)\\]?\\s*(?:in)?\\s*(.*)(?:\\(at line\\s*(\\d+)\\)|:\\[(\\d+)).*(?:\\r?\\n[^\\^\\n]*){1,3}\\r?\\n([^\\^]*)([\\^]+).*\\r?\\n(?:\\s*\\[.*\\]\\s*)?(.*)";

    public EclipseParser() {
        super(ANT_ECLIPSE_WARNING_PATTERN, true);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String type = StringUtils.capitalize((String)matcher.group(1));
        Severity priority = "warning".equalsIgnoreCase(type) ? Severity.WARNING_NORMAL : Severity.WARNING_HIGH;
        int columnStart = StringUtils.defaultString((String)matcher.group(5)).length() + 1;
        int columnEnd = columnStart + matcher.group(6).length();
        return builder.setFileName(matcher.group(2)).setLineStart(this.parseInt(this.getLine(matcher))).setColumnStart(columnStart).setColumnEnd(columnEnd).setMessage(matcher.group(7)).setSeverity(priority).build();
    }

    private String getLine(Matcher matcher) {
        String eclipse34 = matcher.group(3);
        String eclipse38 = matcher.group(4);
        return (String)StringUtils.defaultIfEmpty((CharSequence)eclipse34, (CharSequence)eclipse38);
    }
}

