/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.LineRange;
import edu.hm.hafner.analysis.LineRangeList;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class FindBugsParser
extends IssueParser {
    private static final long serialVersionUID = 8306319007761954027L;
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final int HIGH_PRIORITY_LOWEST_RANK = 4;
    private static final int NORMAL_PRIORITY_LOWEST_RANK = 9;
    private final PriorityProperty priorityProperty;
    private boolean isFirstError = true;

    public FindBugsParser(PriorityProperty priorityProperty) {
        this.priorityProperty = priorityProperty;
    }

    @Override
    public Report parse(File file, Charset charset, Function<String, String> preProcessor) throws ParsingCanceledException, ParsingException {
        ArrayList<String> sources = new ArrayList<String>();
        String moduleRoot = StringUtils.substringBefore((String)file.getAbsolutePath().replace('\\', '/'), (String)"/target/");
        sources.add(moduleRoot + "/src/main/java");
        sources.add(moduleRoot + "/src/test/java");
        sources.add(moduleRoot + "/src");
        return this.parse(() -> new FileInputStream(file), sources, new IssueBuilder());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    Report parse(InputStreamProvider file, Collection<String> sources, IssueBuilder builder) throws ParsingException {
        try (InputStream input = file.getInputStream();){
            HashMap<String, String> hashToMessageMapping = new HashMap<String, String>();
            HashMap<String, String> categories = new HashMap<String, String>();
            for (XmlBugInstance bug : this.preParse(input)) {
                hashToMessageMapping.put(bug.getInstanceHash(), bug.getMessage());
                categories.put(bug.getType(), bug.getCategory());
            }
            Report report = this.parse(file.getInputStream(), sources, builder, hashToMessageMapping, categories);
            return report;
        }
        catch (IOException | DocumentException | SAXException exception) {
            throw new ParsingException(exception);
        }
    }

    @VisibleForTesting
    List<XmlBugInstance> preParse(InputStream file) throws SAXException, IOException {
        SecureDigester digester = new SecureDigester(FindBugsParser.class);
        String rootXPath = "BugCollection/BugInstance";
        digester.addObjectCreate(rootXPath, XmlBugInstance.class);
        digester.addSetProperties(rootXPath);
        String fileXPath = rootXPath + "/LongMessage";
        digester.addCallMethod(fileXPath, "setMessage", 0);
        digester.addSetNext(rootXPath, "add", Object.class.getName());
        ArrayList<XmlBugInstance> bugs = new ArrayList<XmlBugInstance>();
        digester.push(bugs);
        digester.parse(file);
        return bugs;
    }

    private Report parse(InputStream file, Collection<String> sources, IssueBuilder builder, Map<String, String> hashToMessageMapping, Map<String, String> categories) throws IOException, DocumentException {
        SortedBugCollection collection = this.readXml(file);
        Project project = collection.getProject();
        for (String sourceFolder : sources) {
            project.addSourceDir(sourceFolder);
        }
        SourceFinder sourceFinder = new SourceFinder(project);
        if (StringUtils.isNotBlank((CharSequence)project.getProjectName())) {
            builder.setModuleName(project.getProjectName());
        }
        Collection bugs = collection.getCollection();
        Report report = new Report();
        for (BugInstance warning : bugs) {
            SourceLineAnnotation sourceLine = warning.getPrimarySourceLineAnnotation();
            String message = warning.getMessage();
            String type = warning.getType();
            String category = categories.get(type);
            if (category == null) {
                category = warning.getBugPattern().getCategory();
            }
            builder.setSeverity(this.getPriority(warning)).setMessage((String)StringUtils.defaultIfEmpty((CharSequence)hashToMessageMapping.get(warning.getInstanceHash()), (CharSequence)message)).setCategory(category).setType(type).setLineStart(sourceLine.getStartLine()).setLineEnd(sourceLine.getEndLine()).setFileName(this.findSourceFile(project, sourceFinder, sourceLine)).setPackageName(warning.getPrimaryClass().getPackageName()).setFingerprint(warning.getInstanceHash());
            this.setAffectedLines(warning, builder, new LineRange(sourceLine.getStartLine(), sourceLine.getEndLine()));
            report.add(builder.build());
        }
        return report;
    }

    private Severity getPriority(BugInstance warning) {
        if (this.priorityProperty == PriorityProperty.RANK) {
            return this.getPriorityByRank(warning);
        }
        return this.getPriorityByPriority(warning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedBugCollection readXml(InputStream file) throws IOException, DocumentException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(FindBugsParser.class.getClassLoader());
            SortedBugCollection collection = new SortedBugCollection();
            collection.readXML(file);
            SortedBugCollection sortedBugCollection = collection;
            return sortedBugCollection;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void setAffectedLines(BugInstance warning, IssueBuilder builder, LineRange primary) {
        Iterator annotationIterator = warning.annotationIterator();
        LineRangeList lineRanges = new LineRangeList();
        while (annotationIterator.hasNext()) {
            SourceLineAnnotation annotation;
            LineRange lineRange;
            BugAnnotation bugAnnotation = (BugAnnotation)annotationIterator.next();
            if (!(bugAnnotation instanceof SourceLineAnnotation) || lineRanges.contains(lineRange = new LineRange((annotation = (SourceLineAnnotation)bugAnnotation).getStartLine(), annotation.getEndLine())) || primary.equals(lineRange)) continue;
            lineRanges.add(lineRange);
        }
        builder.setLineRanges(lineRanges);
    }

    private String findSourceFile(Project project, SourceFinder sourceFinder, SourceLineAnnotation sourceLine) {
        try {
            SourceFile sourceFile = sourceFinder.findSourceFile(sourceLine);
            return sourceFile.getFullFileName();
        }
        catch (IOException ignored) {
            if (this.isFirstError) {
                StringBuilder builder = new StringBuilder("Can't resolve absolute file name for file ");
                builder.append(sourceLine.getSourceFile());
                builder.append(", dir list = ");
                builder.append(project.getSourceDirList());
                this.isFirstError = false;
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, builder.toString());
            }
            return sourceLine.getPackageName().replace(DOT, SLASH) + SLASH + sourceLine.getSourceFile();
        }
    }

    private Severity getPriorityByRank(BugInstance warning) {
        int rank = warning.getBugRank();
        if (rank <= 4) {
            return Severity.WARNING_HIGH;
        }
        if (rank <= 9) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }

    private Severity getPriorityByPriority(BugInstance warning) {
        switch (warning.getPriority()) {
            case 1: {
                return Severity.WARNING_HIGH;
            }
            case 2: {
                return Severity.WARNING_NORMAL;
            }
        }
        return Severity.WARNING_LOW;
    }

    public static class XmlBugInstance {
        private String instanceHash;
        private String message;
        private String type;
        private String category;

        public String getInstanceHash() {
            return this.instanceHash;
        }

        public void setInstanceHash(String instanceHash) {
            this.instanceHash = instanceHash;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }
    }

    static interface InputStreamProvider {
        public InputStream getInputStream() throws IOException;
    }

    public static enum PriorityProperty {
        CONFIDENCE,
        RANK;

    }
}

