/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class InvalidsParser
extends RegexpLineParser {
    private static final long serialVersionUID = 440910718005095427L;
    static final String WARNING_PREFIX = "Oracle ";
    private static final String INVALIDS_PATTERN = "^\\s*(\\w+),([a-zA-Z#_0-9/]*),([A-Z_ ]*),(.*),(\\d+),\\d+,([^:]*):\\s*(.*)$";

    public InvalidsParser() {
        super(INVALIDS_PATTERN);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String type = WARNING_PREFIX + StringUtils.capitalize((String)StringUtils.lowerCase((String)matcher.group(4)));
        String category = matcher.group(6);
        Severity priority = StringUtils.contains((CharSequence)category, (CharSequence)"PLW-07") ? Severity.WARNING_LOW : (StringUtils.contains((CharSequence)category, (CharSequence)"ORA") ? Severity.WARNING_HIGH : Severity.WARNING_NORMAL);
        return builder.setFileName(matcher.group(2) + "." + matcher.group(3)).setLineStart(this.parseInt(matcher.group(5))).setType(type).setCategory(category).setPackageName(matcher.group(1)).setMessage(matcher.group(7)).setSeverity(priority).build();
    }
}

