/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class MsBuildParser
extends RegexpLineParser {
    private static final long serialVersionUID = -2141974437420906595L;
    private static final String MS_BUILD_WARNING_PATTERN = "(?:^(?:.*)Command line warning ([A-Za-z0-9]+):\\s*(.*)\\s*\\[(.*)\\])|^(?:.*\\[.*\\])?\\s*(?:(?:\\s*\\d+>)?(?:(?:(?:(.*)\\((\\d*)(?:,(\\d+))?.*\\)|.*LINK)\\s*:|(.*):)\\s*([A-z-_]*\\s?(?:[Nn]ote|[Ii]nfo|[Ww]arning|(?:fatal\\s*)?[Ee]rror))\\s*:?\\s*([A-Za-z0-9\\-_]+)\\s*:\\s(?:\\s*([A-Za-z0-9.]+)\\s*:)?\\s*(.*?)(?: \\[([^\\]]*)[/\\\\][^\\]\\\\]+\\])?|(.*)\\s*:.*error\\s*(LNK[0-9]+):\\s*(.*)))$";

    public MsBuildParser() {
        super(MS_BUILD_WARNING_PATTERN);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        builder.setFileName(this.determineFileName(matcher));
        if (StringUtils.isNotBlank((CharSequence)matcher.group(2))) {
            return builder.setLineStart(0).setCategory(matcher.group(1)).setMessage(matcher.group(2)).setSeverity(Severity.WARNING_NORMAL).build();
        }
        if (StringUtils.isNotBlank((CharSequence)matcher.group(13))) {
            return builder.setLineStart(0).setCategory(matcher.group(14)).setMessage(matcher.group(15)).setSeverity(Severity.WARNING_HIGH).build();
        }
        if (StringUtils.isNotEmpty((CharSequence)matcher.group(10))) {
            return builder.setLineStart(this.parseInt(matcher.group(5))).setColumnStart(this.parseInt(matcher.group(6))).setCategory(matcher.group(9)).setType(matcher.group(10)).setMessage(matcher.group(11)).setSeverity(this.determinePriority(matcher)).build();
        }
        String category = matcher.group(9);
        if ("Expected".matches(category)) {
            return FALSE_POSITIVE;
        }
        return builder.setLineStart(this.parseInt(matcher.group(5))).setColumnStart(this.parseInt(matcher.group(6))).setCategory(category).setMessage(matcher.group(11)).setSeverity(this.determinePriority(matcher)).build();
    }

    private String determineFileName(Matcher matcher) {
        String projectDir;
        String fileName = StringUtils.isNotBlank((CharSequence)matcher.group(3)) ? matcher.group(3) : (StringUtils.isNotBlank((CharSequence)matcher.group(7)) ? matcher.group(7) : (StringUtils.isNotBlank((CharSequence)matcher.group(13)) ? matcher.group(13) : matcher.group(4)));
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = StringUtils.substringBetween((String)matcher.group(11), (String)"'");
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = "unknown.file";
        }
        if (this.canResolveRelativeFileName(fileName, projectDir = matcher.group(12))) {
            fileName = FilenameUtils.concat((String)projectDir, (String)fileName);
        }
        return fileName;
    }

    private boolean canResolveRelativeFileName(String fileName, String projectDir) {
        return StringUtils.isNotBlank((CharSequence)projectDir) && FilenameUtils.getPrefixLength((String)fileName) == 0 && !"MSBUILD".equals(fileName.trim());
    }

    private Severity determinePriority(Matcher matcher) {
        if (this.isOfType(matcher, "note") || this.isOfType(matcher, "info")) {
            return Severity.WARNING_LOW;
        }
        if (this.isOfType(matcher, "warning")) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_HIGH;
    }

    private boolean isOfType(Matcher matcher, String type) {
        return StringUtils.containsIgnoreCase((CharSequence)matcher.group(8), (CharSequence)type);
    }
}

