/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpDocumentParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class NagFortranParser
extends RegexpDocumentParser {
    private static final long serialVersionUID = 2072414911276743946L;
    private static final String NAGFOR_MSG_PATTERN = "^(Info|Warning|Questionable|Extension|Obsolescent|Deleted feature used|Error|Runtime Error|Fatal Error|Panic): (.+\\.[^,:\\n]+)(, line (\\d+))?: (.+($\\s+detected at .+)?)";

    public NagFortranParser() {
        super(NAGFOR_MSG_PATTERN, true);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        String category = matcher.group(1);
        return builder.setFileName(matcher.group(2)).setLineStart(this.getLineNumber(matcher)).setCategory(category).setMessage(matcher.group(5)).setSeverity(this.mapPriority(category)).build();
    }

    private Severity mapPriority(String category) {
        switch (category) {
            case "Error": 
            case "Runtime Error": 
            case "Fatal Error": 
            case "Panic": {
                return Severity.WARNING_HIGH;
            }
            case "Info": {
                return Severity.WARNING_LOW;
            }
        }
        return Severity.WARNING_NORMAL;
    }

    private int getLineNumber(Matcher matcher) {
        int lineNumber = StringUtils.isEmpty((CharSequence)matcher.group(4)) ? 0 : Integer.parseInt(matcher.group(4));
        return lineNumber;
    }
}

