/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PuppetLintParser
extends RegexpLineParser {
    private static final long serialVersionUID = 7492869677427430346L;
    private static final String SEPARATOR = "::";
    private static final String PUPPET_LINT_PATTERN_WARNING = "^\\s*((?:[A-Za-z]:)?[^:]+):([0-9]+):([^:]+):((?:WARNING)|(?:ERROR)):\\s*(.*)$";
    private static final String PUPPET_LINT_PATTERN_PACKAGE = "^(.*/?modules/)?([^/]*)/manifests(.*)?(/([^/]*)\\.pp)$";
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("^(.*/?modules/)?([^/]*)/manifests(.*)?(/([^/]*)\\.pp)$");

    public PuppetLintParser() {
        super(PUPPET_LINT_PATTERN_WARNING);
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        return builder.setFileName(matcher.group(1)).setLineStart(this.parseInt(matcher.group(2))).setCategory(matcher.group(3)).setPackageName(this.detectModuleName(matcher.group(1))).setMessage(matcher.group(5)).setSeverity(this.mapPriority(matcher.group(4))).build();
    }

    private Severity mapPriority(String level) {
        Severity priority = Severity.WARNING_NORMAL;
        if (level.contains("error") || level.contains("ERROR")) {
            priority = Severity.WARNING_HIGH;
        }
        return priority;
    }

    private String detectModuleName(String fileName) {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            return this.splitFileName(fileName);
        }
        return "";
    }

    private String splitFileName(String fileName) {
        Matcher matcher = PACKAGE_PATTERN.matcher(fileName);
        if (matcher.find()) {
            String main = matcher.group(2);
            String subclassed = matcher.group(3);
            String module = SEPARATOR + main;
            if (StringUtils.isNotBlank((CharSequence)subclassed)) {
                module = module + StringUtils.replace((String)subclassed, (String)"/", (String)SEPARATOR);
            }
            return module;
        }
        return "";
    }
}

