/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.FastRegexpLineParser;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Severity;
import java.util.regex.Matcher;

public class TnsdlParser
extends FastRegexpLineParser {
    private static final long serialVersionUID = -7740789998865369930L;
    static final String WARNING_CATEGORY = "Error";
    private static final String TNSDL_WARNING_PATTERN = "^tnsdl((.*)?):\\(.*\\) (.*) \\((.*)\\):(.*)$";

    public TnsdlParser() {
        super(TNSDL_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("tnsdl");
    }

    @Override
    protected Issue createIssue(Matcher matcher, IssueBuilder builder) {
        return builder.setFileName(matcher.group(3)).setLineStart(this.parseInt(matcher.group(4))).setCategory(WARNING_CATEGORY).setMessage(matcher.group(5)).setSeverity(this.mapPriority(matcher)).build();
    }

    private Severity mapPriority(Matcher matcher) {
        if (matcher.group().contains("(E)")) {
            return Severity.WARNING_HIGH;
        }
        return Severity.WARNING_NORMAL;
    }
}

