/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.jcreport;

import edu.hm.hafner.analysis.AbstractParser;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingCanceledException;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.jcreport.File;
import edu.hm.hafner.analysis.parser.jcreport.Item;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class JcReportParser
extends AbstractParser {
    private static final long serialVersionUID = -1302787609831475403L;

    @Override
    public Report parse(Reader reader, Function<String, String> preProcessor) throws ParsingCanceledException {
        edu.hm.hafner.analysis.parser.jcreport.Report report = this.createReport(reader);
        Report warnings = new Report();
        for (int i = 0; i < report.getFiles().size(); ++i) {
            File file = report.getFiles().get(i);
            for (int j = 0; j < file.getItems().size(); ++j) {
                Item item = file.getItems().get(j);
                IssueBuilder builder = new IssueBuilder().setFileName(file.getName()).setLineStart(this.parseInt(item.getLine())).setColumnStart(this.parseInt(item.getColumn())).setColumnEnd(this.parseInt(item.getEndcolumn())).setCategory(item.getFindingtype()).setPackageName(file.getPackageName()).setMessage(item.getMessage()).setSeverity(this.getPriority(item.getSeverity()));
                warnings.add(builder.build());
            }
        }
        return warnings;
    }

    private Severity getPriority(String issueLevel) {
        if (StringUtils.isEmpty((CharSequence)issueLevel)) {
            return Severity.WARNING_HIGH;
        }
        if (issueLevel.contains("Error") || issueLevel.contains("Critical")) {
            return Severity.WARNING_HIGH;
        }
        if (issueLevel.contains("Warning")) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public edu.hm.hafner.analysis.parser.jcreport.Report createReport(Reader source) throws ParsingException {
        try (ReaderInputStream input = new ReaderInputStream(source, StandardCharsets.UTF_8);){
            SecureDigester digester = new SecureDigester(JcReportParser.class);
            String report = "report";
            digester.addObjectCreate(report, edu.hm.hafner.analysis.parser.jcreport.Report.class);
            digester.addSetProperties(report);
            String file = "report/file";
            digester.addObjectCreate(file, File.class);
            digester.addSetProperties(file, "package", "packageName");
            digester.addSetProperties(file, "src-dir", "srcdir");
            digester.addSetProperties(file);
            digester.addSetNext(file, "addFile", File.class.getName());
            String item = "report/file/item";
            digester.addObjectCreate(item, Item.class);
            digester.addSetProperties(item);
            digester.addSetProperties(item, "finding-type", "findingtype");
            digester.addSetProperties(item, "end-line", "endline");
            digester.addSetProperties(item, "end-column", "endcolumn");
            digester.addSetNext(item, "addItem", Item.class.getName());
            edu.hm.hafner.analysis.parser.jcreport.Report report2 = (edu.hm.hafner.analysis.parser.jcreport.Report)digester.parse((InputStream)input);
            return report2;
        }
        catch (IOException | SAXException e) {
            throw new ParsingException(e);
        }
    }
}

