/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.SecureXmlParserFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.w3c.dom.Document;
import org.xml.sax.helpers.DefaultHandler;

public abstract class ReaderFactory {
    private static final Function<String, String> IDENTITY = Function.identity();
    private final Charset charset;
    private final Function<String, String> lineMapper;
    private static final Pattern ANSI_COLOR_CODES = Pattern.compile("\u001b\\[[;\\d]*[ -/]*[@-~]");
    private static final Function<String, String> REMOVE_COLOR_CODES = string -> ANSI_COLOR_CODES.matcher((CharSequence)string).replaceAll("");

    public ReaderFactory(Charset charset) {
        this(charset, IDENTITY);
    }

    public ReaderFactory(Charset charset, Function<String, String> lineMapper) {
        this.charset = charset;
        this.lineMapper = REMOVE_COLOR_CODES.compose(lineMapper);
    }

    public abstract String getFileName();

    @MustBeClosed
    public abstract Reader create();

    @MustBeClosed
    @SuppressFBWarnings(value={"OS_OPEN_STREAM"})
    public Stream<String> readStream() {
        try {
            BufferedReader reader = new BufferedReader(this.create());
            Stream stringStream = (Stream)reader.lines().onClose(this.closeReader(reader));
            if (this.hasLineMapper()) {
                return stringStream.map(this.lineMapper);
            }
            return stringStream;
        }
        catch (UncheckedIOException e) {
            throw new ParsingException(e);
        }
    }

    private Runnable closeReader(AutoCloseable closeable) {
        return () -> {
            try {
                closeable.close();
            }
            catch (Exception e) {
                throw new ParsingException(e);
            }
        };
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="test stub")
    private boolean hasLineMapper() {
        return this.lineMapper != null && this.lineMapper != IDENTITY;
    }

    public String readString() {
        String string;
        block8: {
            Stream<String> lines = this.readStream();
            try {
                string = lines.collect(Collectors.joining("\n"));
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UncheckedIOException exception) {
                    throw new ParsingException(exception);
                }
            }
            lines.close();
        }
        return string;
    }

    public Document readDocument() {
        Document document;
        block8: {
            Reader reader = this.create();
            try {
                SecureXmlParserFactory parserFactory = new SecureXmlParserFactory();
                document = parserFactory.readDocument(reader, this.getCharset());
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new ParsingException(exception);
                }
            }
            reader.close();
        }
        return document;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void parse(DefaultHandler handler) {
        try (Reader reader = this.create();){
            new SecureXmlParserFactory().parse(reader, this.getCharset(), handler);
        }
        catch (IOException exception) {
            throw new ParsingException(exception);
        }
    }
}

