/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.IntegerParser;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class ArmccCompilerParser
extends LookaheadParser {
    private static final long serialVersionUID = -2677728927938443703L;
    private static final String ARMCC_WARNING_PATTERN = "^\"(.+)\", line (\\d+): ([A-Z][a-z]+):\\D*(\\d+)\\D*?:\\s+(.+)$";

    public ArmccCompilerParser() {
        super(ARMCC_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String type = matcher.group(3);
        int errorCode = IntegerParser.parseInt(matcher.group(4));
        Severity priority = ArmccCompilerParser.equalsIgnoreCase(type, "error") ? Severity.WARNING_HIGH : Severity.WARNING_NORMAL;
        String message = matcher.group(5);
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setMessage(errorCode + " - " + message).setSeverity(priority).buildOptional();
    }
}

