/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.util.XmlElementUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ClangAnalyzerPlistParser
extends IssueParser {
    private static final long serialVersionUID = 1L;
    static final String ID = "ClangAnalyzer Plist Parser";

    @Override
    public boolean accepts(ReaderFactory readerFactory) {
        return this.isXmlFile(readerFactory);
    }

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        IssueBuilder issueBuilder = new IssueBuilder();
        try {
            Document doc = readerFactory.readDocument();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression filesPath = xPath.compile("/plist/dict/key[text()='files']/following-sibling::array/string");
            XPathExpression diagnosticsPath = xPath.compile("/plist/dict/key[text()='diagnostics']/following-sibling::array/dict");
            XPathExpression diagDescriptionPath = ClangAnalyzerPlistParser.compileDiagStrPath(xPath, "description");
            XPathExpression diagCategoryPath = ClangAnalyzerPlistParser.compileDiagStrPath(xPath, "category");
            XPathExpression diagTypePath = ClangAnalyzerPlistParser.compileDiagStrPath(xPath, "type");
            XPathExpression diagLocationLinePath = ClangAnalyzerPlistParser.compileDiagLocationPath(xPath, "line");
            XPathExpression diagLocationColPath = ClangAnalyzerPlistParser.compileDiagLocationPath(xPath, "col");
            XPathExpression diagLocationFilePath = ClangAnalyzerPlistParser.compileDiagLocationPath(xPath, "file");
            Report report = new Report();
            List<String> files = ClangAnalyzerPlistParser.getFilesList(doc, filesPath);
            NodeList diagnostics = (NodeList)diagnosticsPath.evaluate(doc, XPathConstants.NODESET);
            for (Element diag : XmlElementUtil.nodeListToList(diagnostics)) {
                issueBuilder.setFileName(ClangAnalyzerPlistParser.getFileName(files, diag, diagLocationFilePath)).guessSeverity("Warning").setMessage(ClangAnalyzerPlistParser.extractField(diag, diagDescriptionPath)).setLineStart(ClangAnalyzerPlistParser.extractIntField(diag, diagLocationLinePath)).setColumnStart(ClangAnalyzerPlistParser.extractIntField(diag, diagLocationColPath)).setCategory(ClangAnalyzerPlistParser.extractField(diag, diagCategoryPath)).setType(ClangAnalyzerPlistParser.extractField(diag, diagTypePath));
                report.add(issueBuilder.buildAndClean());
            }
            Report report2 = report;
            issueBuilder.close();
            return report2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    issueBuilder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (XPathExpressionException e) {
                throw new ParsingException(e);
            }
        }
    }

    private static List<String> getFilesList(Document doc, XPathExpression filesPath) throws XPathExpressionException {
        ArrayList<String> files = new ArrayList<String>();
        NodeList nodes = (NodeList)filesPath.evaluate(doc, XPathConstants.NODESET);
        for (Element filePathStr : XmlElementUtil.nodeListToList(nodes)) {
            files.add(filePathStr.getTextContent());
        }
        return files;
    }

    private static String getFileName(List<String> files, Element diag, XPathExpression diagLocationFilePath) throws XPathExpressionException {
        int idx = ClangAnalyzerPlistParser.extractIntField(diag, diagLocationFilePath);
        if (idx >= files.size()) {
            return "-";
        }
        return files.get(idx);
    }

    @SuppressFBWarnings(value={"XPATH_INJECTION"}, justification="parameter is a constant")
    private static XPathExpression compileDiagStrPath(XPath xPath, String field) throws XPathExpressionException {
        String search = "./key[text()='" + field + "']/following-sibling::string";
        return xPath.compile(search);
    }

    @SuppressFBWarnings(value={"XPATH_INJECTION"}, justification="parameter is a constant")
    private static XPathExpression compileDiagLocationPath(XPath xPath, String field) throws XPathExpressionException {
        String search = "./key[text()='location']/following-sibling::dict/key[text()='" + field + "']/following-sibling::integer";
        return xPath.compile(search);
    }

    private static String extractField(Element diag, XPathExpression expr) throws XPathExpressionException {
        NodeList keys = (NodeList)expr.evaluate(diag, XPathConstants.NODESET);
        List<Element> elements = XmlElementUtil.nodeListToList(keys);
        if (elements.isEmpty()) {
            return "";
        }
        return elements.get(0).getTextContent();
    }

    private static int extractIntField(Element diag, XPathExpression expr) throws XPathExpressionException {
        String val = ClangAnalyzerPlistParser.extractField(diag, expr);
        return Integer.parseInt(val);
    }
}

