/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class CodeCheckerParser
extends LookaheadParser {
    private static final long serialVersionUID = -3015592762345283582L;
    private static final String CODE_CHECKER_DEFECT_PATTERN = "^\\[(?<severity>CRITICAL|HIGH|MEDIUM|LOW)\\] (?<path>.+):(?<line>\\d+):(?<column>\\d+): (?<message>.*?) \\[(?<category>[^\\s]*?)\\]$";

    public CodeCheckerParser() {
        super(CODE_CHECKER_DEFECT_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        Severity severity = this.getSeverity(matcher.group("severity"));
        return builder.setFileName(matcher.group("path")).setSeverity(severity).setLineStart(matcher.group("line")).setColumnStart(matcher.group("column")).setCategory(matcher.group("category")).setMessage(matcher.group("message")).buildOptional();
    }

    private Severity getSeverity(String severityText) {
        if (severityText.contains("CRITICAL")) {
            return Severity.ERROR;
        }
        if (severityText.contains("HIGH")) {
            return Severity.WARNING_HIGH;
        }
        if (severityText.contains("MEDIUM")) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }
}

