/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class FlawfinderParser
extends LookaheadParser {
    private static final long serialVersionUID = 8088991846076174837L;
    private static final String FLAWFINDER_WARNING_PATTERN = "^(?<file>.*):(?<line>\\d+): .\\[(?<severity>[012345])\\] \\((?<category>[a-z0-9]*)\\) (?<message>.*)$";
    private static final int FLAWFINDER_HIGH_THRESHOLD = 4;
    private static final int FLAWFINDER_NORMAL_THRESHOLD = 2;

    public FlawfinderParser() {
        super(FLAWFINDER_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String message = matcher.group("message");
        String category = matcher.group("category");
        int severity = Integer.parseInt(matcher.group("severity"));
        Severity priority = Severity.WARNING_LOW;
        if (severity >= 4) {
            priority = Severity.WARNING_HIGH;
        } else if (severity >= 2) {
            priority = Severity.WARNING_NORMAL;
        }
        return builder.setFileName(matcher.group("file")).setLineStart(matcher.group("line")).setCategory(category).setMessage(message).setSeverity(priority).buildOptional();
    }
}

