/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import org.json.JSONArray;
import org.json.JSONObject;

public class HadoLintParser
extends JsonIssueParser {
    private static final long serialVersionUID = 1618503559862246224L;

    @Override
    protected void parseJsonArray(Report report, JSONArray jsonReport, IssueBuilder issueBuilder) {
        for (Object issue : jsonReport) {
            if (!(issue instanceof JSONObject)) continue;
            report.add(this.convertToIssue((JSONObject)issue, issueBuilder));
        }
    }

    Issue convertToIssue(JSONObject jsonIssue, IssueBuilder issueBuilder) {
        if (jsonIssue.has("code")) {
            issueBuilder.setCategory(jsonIssue.getString("code"));
        }
        if (jsonIssue.has("level")) {
            issueBuilder.setSeverity(this.toSeverity(jsonIssue.getString("level")));
        }
        if (jsonIssue.has("line")) {
            issueBuilder.setLineStart(jsonIssue.getInt("line"));
        }
        if (jsonIssue.has("column")) {
            issueBuilder.setColumnStart(jsonIssue.getInt("column"));
        }
        if (jsonIssue.has("message")) {
            issueBuilder.setMessage(jsonIssue.getString("message"));
        }
        if (jsonIssue.has("file")) {
            issueBuilder.setFileName(jsonIssue.getString("file"));
        }
        return issueBuilder.buildAndClean();
    }

    private Severity toSeverity(String level) {
        switch (level) {
            case "style": {
                return Severity.WARNING_LOW;
            }
            case "info": {
                return Severity.WARNING_NORMAL;
            }
            case "warning": {
                return Severity.WARNING_HIGH;
            }
            case "error": {
                return Severity.ERROR;
            }
        }
        return Severity.WARNING_LOW;
    }
}

