/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class IarCstatParser
extends LookaheadParser {
    private static final long serialVersionUID = 7695540852439013425L;
    private static final String IAR_WARNING_PATTERN = "^(?:.*\\[[^]]*\\])?\\s*(?:\"?(.*?)\"?[\\(,](\\d+)\\)?\\s+)?(Severity-(?:Low|Medium|High))\\[(\\S+)\\]:(.*)$";

    public IarCstatParser() {
        super(IAR_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("Severity-");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        return builder.setSeverity(this.mapSeverity(matcher.group(3))).setMessage(this.normalizeWhitespaceInMessage(matcher.group(5))).setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setCategory(matcher.group(4)).buildOptional();
    }

    private Severity mapSeverity(String category) {
        Severity severity = "Severity-Low".equals(category) ? Severity.WARNING_LOW : ("Severity-High".equals(category) ? Severity.WARNING_HIGH : Severity.WARNING_NORMAL);
        return severity;
    }

    private String normalizeWhitespaceInMessage(String message) {
        return message.replaceAll("\\s+", " ");
    }
}

