/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class PyLintParser
extends LookaheadParser {
    private static final long serialVersionUID = 4464053085862883240L;
    private static final String PYLINT_PATTERN = "(?<path>(?:[A-Z]:\\\\)?[^:]*)(?:\\:(?<module>.*))?:(?<line>\\d+): \\[(?<type>(?<category>[A-Z])\\d*)?(?:\\((?<symbol>.*)\\), )?.*?\\] (?<message>.*)";
    private static final String UNKNOWN_CAT = "pylint-unknown-category";
    private static final String UNKNOWN_TYPE = "pylint-unknown-type";

    public PyLintParser() {
        super(PYLINT_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("[");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String category = matcher.group("category");
        builder.setSeverity(this.mapPriority(category));
        builder.setCategory(this.mapCategory(category));
        builder.setType((String)StringUtils.firstNonBlank((CharSequence[])new String[]{matcher.group("symbol"), matcher.group("type"), UNKNOWN_TYPE}));
        String moduleName = matcher.group("module");
        if (moduleName == null) {
            builder.setPackageName("-").setModuleName("-");
        } else {
            if (moduleName.contains(".")) {
                builder.setPackageName(moduleName.substring(0, moduleName.lastIndexOf(46)));
            } else {
                builder.setPackageName("-");
            }
            builder.setModuleName(moduleName);
        }
        return builder.setFileName(matcher.group("path")).setLineStart(matcher.group("line")).setMessage(matcher.group("message")).buildOptional();
    }

    private String mapCategory(String category) {
        if (StringUtils.isEmpty((CharSequence)category)) {
            return UNKNOWN_CAT;
        }
        switch (category) {
            case "I": {
                return "Informational";
            }
            case "R": {
                return "Refactor";
            }
            case "C": {
                return "Convention";
            }
            case "W": {
                return "Warning";
            }
            case "E": {
                return "Error";
            }
            case "F": {
                return "Fatal";
            }
        }
        return UNKNOWN_CAT;
    }

    private Severity mapPriority(String category) {
        if (StringUtils.isEmpty((CharSequence)category)) {
            return Severity.WARNING_NORMAL;
        }
        switch (category) {
            case "I": 
            case "R": 
            case "C": {
                return Severity.WARNING_LOW;
            }
            case "W": {
                return Severity.WARNING_NORMAL;
            }
            case "E": {
                return Severity.WARNING_HIGH;
            }
            case "F": {
                return Severity.ERROR;
            }
        }
        return Severity.WARNING_LOW;
    }
}

