/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Categories;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class RuboCopParser
extends LookaheadParser {
    private static final long serialVersionUID = 7199325311690082783L;
    private static final String RUBOCOP_WARNING_PATTERN = "^(?<file>.[^:]+):(?<line>\\d+):(?<column>\\d+): (?<severity>[RCWEF]): (\\[Correctable\\] )?(?<category>\\S+): (?<message>.*)$";
    private static final String ERROR = "E";
    private static final String FATAL = "F";

    public RuboCopParser() {
        super(RUBOCOP_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        String message = matcher.group("message");
        String category = Categories.guessCategoryIfEmpty(matcher.group("category"), message);
        String severity = matcher.group("severity");
        Severity priority = Severity.WARNING_NORMAL;
        if (ERROR.equals(severity) || FATAL.equals(severity)) {
            priority = Severity.WARNING_HIGH;
        }
        return builder.setFileName(matcher.group("file")).setLineStart(matcher.group("line")).setCategory(category).setMessage(message).setSeverity(priority).setColumnStart(matcher.group("column")).buildOptional();
    }
}

