/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.MessageFormat;
import org.json.JSONArray;
import org.json.JSONObject;

public class TrivyParser
extends JsonIssueParser {
    private static final String VALUE_NOT_SET = "-";
    private static final String TRIVY_VULNERABILITY_LEVEL_TAG_CRITICAL = "critcal";
    private static final String TRIVY_VULNERABILITY_LEVEL_TAG_HIGH = "high";
    private static final String TRIVY_VULNERABILITY_LEVEL_TAG_MEDIUM = "medium";
    private static final String TRIVY_VULNERABILITY_LEVEL_TAG_LOW = "low";
    private static final long serialVersionUID = 1L;

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        JSONArray results = jsonReport.optJSONArray("Results");
        if (results != null) {
            this.parseResults(report, results, issueBuilder);
        }
    }

    @Override
    protected void parseJsonArray(Report report, JSONArray jsonReport, IssueBuilder issueBuilder) {
        this.parseResults(report, jsonReport, issueBuilder);
    }

    private void parseResults(Report report, JSONArray jsonReport, IssueBuilder issueBuilder) {
        for (int i = 0; i < jsonReport.length(); ++i) {
            JSONObject component = (JSONObject)jsonReport.get(i);
            if (component.isNull("Vulnerabilities")) continue;
            JSONArray vulnerabilities = component.getJSONArray("Vulnerabilities");
            for (Object vulnerability : vulnerabilities) {
                report.add(this.convertToIssue((JSONObject)vulnerability, issueBuilder));
            }
        }
    }

    private Issue convertToIssue(JSONObject vulnerability, IssueBuilder issueBuilder) {
        return issueBuilder.setFileName(vulnerability.optString("PkgName", VALUE_NOT_SET)).setCategory(vulnerability.optString("SeveritySource", VALUE_NOT_SET)).setSeverity(this.mapSeverity(vulnerability.optString("Severity", "UNKNOWN"))).setType(vulnerability.optString("VulnerabilityID", VALUE_NOT_SET)).setMessage(vulnerability.optString("Title", "UNKNOWN")).setDescription(this.formatDescription(vulnerability)).buildAndClean();
    }

    @SuppressFBWarnings(value={"IMPROPER_UNICODE"})
    private Severity mapSeverity(String string) {
        if (TRIVY_VULNERABILITY_LEVEL_TAG_LOW.equalsIgnoreCase(string)) {
            return Severity.WARNING_LOW;
        }
        if (TRIVY_VULNERABILITY_LEVEL_TAG_MEDIUM.equalsIgnoreCase(string)) {
            return Severity.WARNING_NORMAL;
        }
        if (TRIVY_VULNERABILITY_LEVEL_TAG_HIGH.equalsIgnoreCase(string) || TRIVY_VULNERABILITY_LEVEL_TAG_CRITICAL.equalsIgnoreCase(string)) {
            return Severity.WARNING_HIGH;
        }
        return Severity.WARNING_HIGH;
    }

    private String formatDescription(JSONObject vulnerability) {
        return MessageFormat.format("<p><div><b>File</b>: {0}</div><div><b>Installed Version:</b> {1}</div><div><b>Fixed Version:</b> {2}</div><div><b>Severity:</b> {3}</div>", vulnerability.optString("PkgName", VALUE_NOT_SET), vulnerability.optString("InstalledVersion", VALUE_NOT_SET), vulnerability.optString("FixedVersion", "still open"), vulnerability.optString("Severity", "UNKOWN")) + "<p>" + vulnerability.optString("Description", "") + "</p>";
    }
}

