/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.checkstyle;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.analysis.parser.checkstyle.CheckStyle;
import edu.hm.hafner.analysis.parser.checkstyle.Error;
import edu.hm.hafner.analysis.parser.checkstyle.File;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class CheckStyleParser
extends IssueParser {
    private static final long serialVersionUID = -3187275729854832128L;

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        Report report;
        block9: {
            SecureDigester digester = new SecureDigester(CheckStyleParser.class);
            String rootXPath = "checkstyle";
            digester.addObjectCreate(rootXPath, CheckStyle.class);
            digester.addSetProperties(rootXPath);
            String fileXPath = "checkstyle/file";
            digester.addObjectCreate(fileXPath, File.class);
            digester.addSetProperties(fileXPath);
            digester.addSetNext(fileXPath, "addFile", File.class.getName());
            String bugXPath = "checkstyle/file/error";
            digester.addObjectCreate(bugXPath, Error.class);
            digester.addSetProperties(bugXPath);
            digester.addSetNext(bugXPath, "addError", Error.class.getName());
            Reader reader = readerFactory.create();
            try {
                CheckStyle checkStyle = (CheckStyle)digester.parse(reader);
                if (checkStyle == null) {
                    throw new ParsingException("Input stream is not a Checkstyle file.", new Object[0]);
                }
                report = this.convert(checkStyle);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException exception) {
                    throw new ParsingException(exception);
                }
            }
            reader.close();
        }
        return report;
    }

    private Report convert(CheckStyle collection) {
        try (IssueBuilder issueBuilder = new IssueBuilder();){
            Report report = new Report();
            for (File file : collection.getFiles()) {
                if (!this.isValidWarning(file)) continue;
                for (Error error : file.getErrors()) {
                    issueBuilder.guessSeverity(error.getSeverity());
                    String source = error.getSource();
                    issueBuilder.setType(this.getType(source));
                    issueBuilder.setCategory(this.getCategory(source));
                    issueBuilder.setMessage(error.getMessage());
                    issueBuilder.setLineStart(error.getLine());
                    issueBuilder.setFileName(file.getName());
                    issueBuilder.setColumnStart(error.getColumn());
                    report.add(issueBuilder.buildAndClean());
                }
            }
            Report report2 = report;
            return report2;
        }
    }

    @CheckForNull
    private String getCategory(@CheckForNull String source) {
        return StringUtils.capitalize((String)this.getType(StringUtils.substringBeforeLast((String)source, (String)".")));
    }

    @CheckForNull
    private String getType(@CheckForNull String source) {
        if (StringUtils.contains((CharSequence)source, (int)46)) {
            return StringUtils.substringAfterLast((String)source, (String)".");
        }
        return source;
    }

    private boolean isValidWarning(File file) {
        return !StringUtils.endsWith((CharSequence)file.getName(), (CharSequence)"package.html");
    }
}

