/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.fxcop;

import edu.hm.hafner.analysis.parser.fxcop.FxCopRule;
import edu.hm.hafner.util.XmlElementUtil;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.w3c.dom.Element;

public class FxCopRuleSet {
    private final Map<String, FxCopRule> rules = new HashMap<String, FxCopRule>();

    public void addRule(Element element) {
        FxCopRule rule = new FxCopRule(element.getAttribute("TypeName"), element.getAttribute("Category"), element.getAttribute("CheckId"));
        rule.setUrl(this.getNamedTagText(element, "Url"));
        rule.setDescription(this.getNamedTagText(element, "Description"));
        rule.setName(this.getNamedTagText(element, "Name"));
        this.rules.put(this.getRuleKey(rule.getCategory(), rule.getCheckId()), rule);
    }

    private String getNamedTagText(Element element, String tagName) {
        Optional<Element> foundElement = XmlElementUtil.getFirstChildElementByName(element, tagName);
        if (foundElement.isPresent()) {
            return foundElement.get().getTextContent();
        }
        return "";
    }

    public boolean contains(String category, String checkId) {
        return this.rules.containsKey(this.getRuleKey(category, checkId));
    }

    @CheckForNull
    public FxCopRule getRule(String category, String checkId) {
        String key = this.getRuleKey(category, checkId);
        FxCopRule rule = null;
        if (this.rules.containsKey(key)) {
            rule = this.rules.get(key);
        }
        return rule;
    }

    private String getRuleKey(String category, String checkId) {
        return category + "#" + checkId;
    }
}

