/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.registry;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.parser.checkstyle.CheckStyleParser;
import edu.hm.hafner.analysis.parser.checkstyle.CheckStyleRules;
import edu.hm.hafner.analysis.registry.ParserDescriptor;
import edu.hm.hafner.util.Deferred;

class CheckStyleDescriptor
extends ParserDescriptor {
    private static final String ID = "checkstyle";
    private static final String NAME = "CheckStyle";
    private final Deferred<CheckStyleRules> messages = new Deferred<CheckStyleRules>(CheckStyleRules::new);

    CheckStyleDescriptor() {
        super(ID, NAME);
    }

    @Override
    public IssueParser createParser(ParserDescriptor.Option ... options) {
        return new CheckStyleParser();
    }

    @Override
    public String getPattern() {
        return "**/checkstyle-result.xml";
    }

    @Override
    public String getUrl() {
        return "https://checkstyle.org";
    }

    @Override
    public String getIconUrl() {
        return "https://github.com/checkstyle/checkstyle/blob/master/src/site/resources/images/checkstyle_logo_small_64.png";
    }

    @Override
    public String getDescription(Issue issue) {
        return this.messages.get().getDescription(issue.getType());
    }
}

