/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.registry;

import edu.hm.hafner.analysis.registry.AcuCobolDescriptor;
import edu.hm.hafner.analysis.registry.AjcDescriptor;
import edu.hm.hafner.analysis.registry.AndroidLintDescriptor;
import edu.hm.hafner.analysis.registry.AnsibleLintDescriptor;
import edu.hm.hafner.analysis.registry.AquaScannerDescriptor;
import edu.hm.hafner.analysis.registry.ArmccCompilerDescriptor;
import edu.hm.hafner.analysis.registry.BrakemanDescriptor;
import edu.hm.hafner.analysis.registry.BuckminsterDescriptor;
import edu.hm.hafner.analysis.registry.CadenceIncisiveDescriptor;
import edu.hm.hafner.analysis.registry.CargoDescriptor;
import edu.hm.hafner.analysis.registry.CcmDescriptor;
import edu.hm.hafner.analysis.registry.CheckStyleDescriptor;
import edu.hm.hafner.analysis.registry.ClairDescriptor;
import edu.hm.hafner.analysis.registry.ClangAnalyzerDescriptor;
import edu.hm.hafner.analysis.registry.ClangDescriptor;
import edu.hm.hafner.analysis.registry.ClangTidyDescriptor;
import edu.hm.hafner.analysis.registry.CmakeDescriptor;
import edu.hm.hafner.analysis.registry.CodeAnalysisDescriptor;
import edu.hm.hafner.analysis.registry.CodeCheckerDescriptor;
import edu.hm.hafner.analysis.registry.CodeNarcDescriptor;
import edu.hm.hafner.analysis.registry.CoolfluxChessccDescriptor;
import edu.hm.hafner.analysis.registry.CpdDescriptor;
import edu.hm.hafner.analysis.registry.CppCheckDescriptor;
import edu.hm.hafner.analysis.registry.CppLintDescriptor;
import edu.hm.hafner.analysis.registry.CssLintDescriptor;
import edu.hm.hafner.analysis.registry.DScannerDescriptor;
import edu.hm.hafner.analysis.registry.DartAnalyzeDescriptor;
import edu.hm.hafner.analysis.registry.DetektDescriptor;
import edu.hm.hafner.analysis.registry.DiabCDescriptor;
import edu.hm.hafner.analysis.registry.DocFxDescriptor;
import edu.hm.hafner.analysis.registry.DockerLintDescriptor;
import edu.hm.hafner.analysis.registry.DoxygenDescriptor;
import edu.hm.hafner.analysis.registry.DrMemoryDescriptor;
import edu.hm.hafner.analysis.registry.DupfinderDescriptor;
import edu.hm.hafner.analysis.registry.EclipseDescriptor;
import edu.hm.hafner.analysis.registry.ErlcDescriptor;
import edu.hm.hafner.analysis.registry.ErrorProneDescriptor;
import edu.hm.hafner.analysis.registry.EsLintDescriptor;
import edu.hm.hafner.analysis.registry.FindBugsDescriptor;
import edu.hm.hafner.analysis.registry.Flake8Descriptor;
import edu.hm.hafner.analysis.registry.FlawfinderDescriptor;
import edu.hm.hafner.analysis.registry.FlexSdkDescriptor;
import edu.hm.hafner.analysis.registry.FlowDescriptor;
import edu.hm.hafner.analysis.registry.FoodCriticDescriptor;
import edu.hm.hafner.analysis.registry.FxcopDescriptor;
import edu.hm.hafner.analysis.registry.Gcc4Descriptor;
import edu.hm.hafner.analysis.registry.GccDescriptor;
import edu.hm.hafner.analysis.registry.GendarmeDescriptor;
import edu.hm.hafner.analysis.registry.GhsMultiDescriptor;
import edu.hm.hafner.analysis.registry.GnatDescriptor;
import edu.hm.hafner.analysis.registry.GnuFortranDescriptor;
import edu.hm.hafner.analysis.registry.GoLintDescriptor;
import edu.hm.hafner.analysis.registry.GoVetDescriptor;
import edu.hm.hafner.analysis.registry.HadoLintDescriptor;
import edu.hm.hafner.analysis.registry.IarCstatDescriptor;
import edu.hm.hafner.analysis.registry.IarDescriptor;
import edu.hm.hafner.analysis.registry.IbLinterDescriptor;
import edu.hm.hafner.analysis.registry.IdeaInspectionDescriptor;
import edu.hm.hafner.analysis.registry.InferDescriptor;
import edu.hm.hafner.analysis.registry.IntelDescriptor;
import edu.hm.hafner.analysis.registry.InvalidsDescriptor;
import edu.hm.hafner.analysis.registry.JUnitDescriptor;
import edu.hm.hafner.analysis.registry.JavaDescriptor;
import edu.hm.hafner.analysis.registry.JavaDocDescriptor;
import edu.hm.hafner.analysis.registry.JcreportDescriptor;
import edu.hm.hafner.analysis.registry.JsHintDescriptor;
import edu.hm.hafner.analysis.registry.JsLintDescriptor;
import edu.hm.hafner.analysis.registry.KlocWorkDescriptor;
import edu.hm.hafner.analysis.registry.KotlinDescriptor;
import edu.hm.hafner.analysis.registry.KtLintDescriptor;
import edu.hm.hafner.analysis.registry.MavenConsoleDescriptor;
import edu.hm.hafner.analysis.registry.MentorGraphicsDescriptor;
import edu.hm.hafner.analysis.registry.MetrowerksCodeWarriorDescriptor;
import edu.hm.hafner.analysis.registry.MsBuildDescriptor;
import edu.hm.hafner.analysis.registry.MyPyDescriptor;
import edu.hm.hafner.analysis.registry.NagFortranDescriptor;
import edu.hm.hafner.analysis.registry.NativeFormatDescriptor;
import edu.hm.hafner.analysis.registry.OELintAdvDescriptor;
import edu.hm.hafner.analysis.registry.OtDockerLintDescriptor;
import edu.hm.hafner.analysis.registry.OwaspDependencyCheckDescriptor;
import edu.hm.hafner.analysis.registry.ParserDescriptor;
import edu.hm.hafner.analysis.registry.PcLintDescriptor;
import edu.hm.hafner.analysis.registry.Pep8Descriptor;
import edu.hm.hafner.analysis.registry.PerforceDescriptor;
import edu.hm.hafner.analysis.registry.PerlCriticDescriptor;
import edu.hm.hafner.analysis.registry.PhpCodeSnifferDescriptor;
import edu.hm.hafner.analysis.registry.PhpDescriptor;
import edu.hm.hafner.analysis.registry.PhpStanDescriptor;
import edu.hm.hafner.analysis.registry.PitDescriptor;
import edu.hm.hafner.analysis.registry.PmdDescriptor;
import edu.hm.hafner.analysis.registry.PreFastDescriptor;
import edu.hm.hafner.analysis.registry.ProtoLintDescriptor;
import edu.hm.hafner.analysis.registry.PuppetLintDescriptor;
import edu.hm.hafner.analysis.registry.PvsStudioDescriptor;
import edu.hm.hafner.analysis.registry.PyDocStyleDescriptor;
import edu.hm.hafner.analysis.registry.PyLintDescriptor;
import edu.hm.hafner.analysis.registry.QacSourceCodeAnalyserDescriptor;
import edu.hm.hafner.analysis.registry.QtTranslationDescriptor;
import edu.hm.hafner.analysis.registry.ResharperDescriptor;
import edu.hm.hafner.analysis.registry.RfLintDescriptor;
import edu.hm.hafner.analysis.registry.RoboCopyDescriptor;
import edu.hm.hafner.analysis.registry.RuboCopDescriptor;
import edu.hm.hafner.analysis.registry.SarifDescriptor;
import edu.hm.hafner.analysis.registry.ScalaDescriptor;
import edu.hm.hafner.analysis.registry.SimianDescriptor;
import edu.hm.hafner.analysis.registry.SonarQubeDescriptor;
import edu.hm.hafner.analysis.registry.SphinxBuildDescriptor;
import edu.hm.hafner.analysis.registry.SpotBugsDescriptor;
import edu.hm.hafner.analysis.registry.StyleCopDescriptor;
import edu.hm.hafner.analysis.registry.SunCDescriptor;
import edu.hm.hafner.analysis.registry.SwiftLintDescriptor;
import edu.hm.hafner.analysis.registry.TaglistDescriptor;
import edu.hm.hafner.analysis.registry.TaskingVxCompilerDescriptor;
import edu.hm.hafner.analysis.registry.TiCcsDescriptor;
import edu.hm.hafner.analysis.registry.TnsdlDescriptor;
import edu.hm.hafner.analysis.registry.TrivyDescriptor;
import edu.hm.hafner.analysis.registry.TsLintDescriptor;
import edu.hm.hafner.analysis.registry.XlcDescriptor;
import edu.hm.hafner.analysis.registry.XmlLintDescriptor;
import edu.hm.hafner.analysis.registry.YamlLintDescriptor;
import edu.hm.hafner.analysis.registry.YuiCompressorDescriptor;
import edu.hm.hafner.analysis.registry.ZptLintDescriptor;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.EmptyTag;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ParserRegistry {
    private static final String BULB_EMOJI = ":bulb:";
    private static final ParserDescriptor[] ALL_DESCRIPTORS = new ParserDescriptor[]{new AcuCobolDescriptor(), new AjcDescriptor(), new AndroidLintDescriptor(), new AnsibleLintDescriptor(), new AquaScannerDescriptor(), new ArmccCompilerDescriptor(), new BrakemanDescriptor(), new BuckminsterDescriptor(), new CadenceIncisiveDescriptor(), new CargoDescriptor(), new CcmDescriptor(), new CheckStyleDescriptor(), new ClairDescriptor(), new ClangAnalyzerDescriptor(), new ClangDescriptor(), new ClangTidyDescriptor(), new CmakeDescriptor(), new CodeAnalysisDescriptor(), new CodeCheckerDescriptor(), new CodeNarcDescriptor(), new CoolfluxChessccDescriptor(), new CpdDescriptor(), new CppCheckDescriptor(), new CppLintDescriptor(), new CssLintDescriptor(), new DartAnalyzeDescriptor(), new DetektDescriptor(), new DiabCDescriptor(), new DocFxDescriptor(), new DockerLintDescriptor(), new DoxygenDescriptor(), new DrMemoryDescriptor(), new DScannerDescriptor(), new DupfinderDescriptor(), new EclipseDescriptor(), new ErlcDescriptor(), new ErrorProneDescriptor(), new EsLintDescriptor(), new FindBugsDescriptor(), new Flake8Descriptor(), new FlawfinderDescriptor(), new FlexSdkDescriptor(), new FlowDescriptor(), new FoodCriticDescriptor(), new FxcopDescriptor(), new Gcc4Descriptor(), new GccDescriptor(), new GendarmeDescriptor(), new GhsMultiDescriptor(), new GnatDescriptor(), new GnuFortranDescriptor(), new GoLintDescriptor(), new GoVetDescriptor(), new HadoLintDescriptor(), new IarCstatDescriptor(), new IarDescriptor(), new IbLinterDescriptor(), new IdeaInspectionDescriptor(), new InferDescriptor(), new IntelDescriptor(), new InvalidsDescriptor(), new JavaDescriptor(), new JavaDocDescriptor(), new JcreportDescriptor(), new JsHintDescriptor(), new JsLintDescriptor(), new JUnitDescriptor(), new KlocWorkDescriptor(), new KotlinDescriptor(), new KtLintDescriptor(), new MavenConsoleDescriptor(), new MentorGraphicsDescriptor(), new MetrowerksCodeWarriorDescriptor(), new MsBuildDescriptor(), new MyPyDescriptor(), new NagFortranDescriptor(), new NativeFormatDescriptor(), new OELintAdvDescriptor(), new OtDockerLintDescriptor(), new OwaspDependencyCheckDescriptor(), new PcLintDescriptor(), new Pep8Descriptor(), new PerforceDescriptor(), new PerlCriticDescriptor(), new PhpCodeSnifferDescriptor(), new PhpDescriptor(), new PhpStanDescriptor(), new PitDescriptor(), new PmdDescriptor(), new PreFastDescriptor(), new ProtoLintDescriptor(), new PuppetLintDescriptor(), new PvsStudioDescriptor(), new PyDocStyleDescriptor(), new PyLintDescriptor(), new QacSourceCodeAnalyserDescriptor(), new QtTranslationDescriptor(), new ResharperDescriptor(), new RfLintDescriptor(), new RoboCopyDescriptor(), new RuboCopDescriptor(), new SarifDescriptor(), new ScalaDescriptor(), new SimianDescriptor(), new SonarQubeDescriptor(), new SphinxBuildDescriptor(), new SpotBugsDescriptor(), new StyleCopDescriptor(), new SunCDescriptor(), new SwiftLintDescriptor(), new TaglistDescriptor(), new TaskingVxCompilerDescriptor(), new TiCcsDescriptor(), new TnsdlDescriptor(), new TrivyDescriptor(), new TsLintDescriptor(), new XlcDescriptor(), new YamlLintDescriptor(), new XmlLintDescriptor(), new YuiCompressorDescriptor(), new ZptLintDescriptor()};
    private final Map<String, ParserDescriptor> descriptors = Arrays.stream(ALL_DESCRIPTORS).collect(Collectors.toMap(ParserDescriptor::getId, Function.identity()));

    public Set<String> getIds() {
        return new HashSet<String>(this.descriptors.keySet());
    }

    public Set<String> getNames() {
        return this.descriptors.values().stream().map(ParserDescriptor::getName).collect(Collectors.toSet());
    }

    public boolean contains(String id) {
        return this.descriptors.containsKey(id);
    }

    public ParserDescriptor get(String id) {
        if (this.descriptors.containsKey(id)) {
            return this.descriptors.get(id);
        }
        throw new NoSuchElementException("No such parser registered: " + id);
    }

    public List<ParserDescriptor> getAllDescriptors() {
        return new ArrayList<ParserDescriptor>(this.descriptors.values());
    }

    public static void main(String[] unused) throws IOException {
        List<ParserDescriptor> descriptors = new ParserRegistry().getAllDescriptors();
        descriptors.sort(Comparator.comparing(ParserDescriptor::getName));
        try (PrintWriter file = new PrintWriter("SUPPORTED-FORMATS.md", "UTF-8");){
            file.printf("<!--- DO NOT EDIT - Generated by %s at %s-->%n", ParserRegistry.class.getSimpleName(), LocalDateTime.now(ZoneId.of("Europe/Berlin")));
            file.println("# Supported Report Formats\n\nThe static analysis model supports the following report formats.\n\nIf your tool is not yet supported you can\n1. export the issues of your tool to the native XML or JSON format (or any other format).\n2. provide a [pull request](https://github.com/jenkinsci/analysis-model/pulls) with a new parser.\n\nIf your tool is supported, but some properties are missing (icon, URL, etc.), please file a\n[pull request](https://github.com/jenkinsci/analysis-model/pulls).\n\n");
            List lines = descriptors.stream().map(ParserRegistry::getTableRows).flatMap(Collection::stream).collect(Collectors.toList());
            file.println(TagCreator.table().with(new DomContent[]{TagCreator.thead().with((DomContent)TagCreator.tr().with(new DomContent[]{TagCreator.th((String)"ID"), TagCreator.th((String)"Icons"), TagCreator.th((String)"Name"), TagCreator.th((String)"Default Pattern")})), TagCreator.tbody().with(lines)}).renderFormatted());
        }
    }

    private static List<ContainerTag> getTableRows(ParserDescriptor descriptor) {
        ArrayList<ContainerTag> rows = new ArrayList<ContainerTag>();
        rows.add(TagCreator.tr().with(new DomContent[]{TagCreator.td((String)descriptor.getId()), TagCreator.td((DomContent[])new DomContent[]{ParserRegistry.getIcon(descriptor)}), TagCreator.td((DomContent[])new DomContent[]{ParserRegistry.getName(descriptor)}), TagCreator.td((String)((String)StringUtils.defaultIfBlank((CharSequence)descriptor.getPattern(), (CharSequence)"-")))}));
        if (descriptor.hasHelp()) {
            rows.add(TagCreator.tr().with((DomContent)((ContainerTag)TagCreator.td().attr("colspan", (Object)"4")).with((DomContent)TagCreator.join((Object[])new Object[]{BULB_EMOJI, TagCreator.rawHtml((String)descriptor.getHelp())}))));
        }
        return rows;
    }

    private static DomContent getName(ParserDescriptor descriptor) {
        String name = descriptor.getName();
        String url = descriptor.getUrl();
        if (url.isEmpty()) {
            return TagCreator.text((String)name);
        }
        return TagCreator.a((String)name).withHref(url);
    }

    private static DomContent getIcon(ParserDescriptor descriptor) {
        String url = descriptor.getIconUrl();
        if (url.isEmpty()) {
            return TagCreator.text((String)"-");
        }
        return ((EmptyTag)((EmptyTag)((EmptyTag)TagCreator.img().withSrc(url)).withAlt(descriptor.getName())).attr("height", (Object)"64")).attr("width", (Object)64);
    }
}

