/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlElementUtil {
    public static List<Element> getChildElementsByName(Element parent, String name) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (parent != null) {
            for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
                elements.add((Element)child);
            }
        }
        return elements;
    }

    public static Optional<Element> getFirstChildElementByName(Element parent, String name) {
        return XmlElementUtil.getChildElementsByName(parent, name).stream().findFirst();
    }

    public static List<Element> nodeListToList(@CheckForNull NodeList nodeList) {
        if (nodeList == null) {
            return new ArrayList<Element>();
        }
        int length = nodeList.getLength();
        ArrayList<Element> elements = new ArrayList<Element>(length);
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    private XmlElementUtil() {
    }
}

