/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.LineRange;
import edu.hm.hafner.analysis.Severity;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class IssueAssert
extends AbstractObjectAssert<IssueAssert, Issue> {
    public IssueAssert(Issue actual) {
        super((Object)actual, IssueAssert.class);
    }

    @CheckReturnValue
    public static IssueAssert assertThat(Issue actual) {
        return new IssueAssert(actual);
    }

    public IssueAssert hasAbsolutePath(String absolutePath) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting absolutePath of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualAbsolutePath = ((Issue)this.actual).getAbsolutePath();
        if (!Objects.deepEquals(actualAbsolutePath, absolutePath)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, absolutePath, actualAbsolutePath});
        }
        return this;
    }

    public IssueAssert hasAdditionalProperties(Serializable additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Serializable actualAdditionalProperties = ((Issue)this.actual).getAdditionalProperties();
        if (!Objects.deepEquals(actualAdditionalProperties, additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return this;
    }

    public IssueAssert hasBaseName(String baseName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting baseName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualBaseName = ((Issue)this.actual).getBaseName();
        if (!Objects.deepEquals(actualBaseName, baseName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, baseName, actualBaseName});
        }
        return this;
    }

    public IssueAssert hasCategory(String category) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting category of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualCategory = ((Issue)this.actual).getCategory();
        if (!Objects.deepEquals(actualCategory, category)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, category, actualCategory});
        }
        return this;
    }

    public IssueAssert hasColumnEnd(int columnEnd) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting columnEnd of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualColumnEnd = ((Issue)this.actual).getColumnEnd();
        if (actualColumnEnd != columnEnd) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, columnEnd, actualColumnEnd});
        }
        return this;
    }

    public IssueAssert hasColumnStart(int columnStart) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting columnStart of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualColumnStart = ((Issue)this.actual).getColumnStart();
        if (actualColumnStart != columnStart) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, columnStart, actualColumnStart});
        }
        return this;
    }

    public IssueAssert hasDescription(String description) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting description of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDescription = ((Issue)this.actual).getDescription();
        if (!Objects.deepEquals(actualDescription, description)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, description, actualDescription});
        }
        return this;
    }

    public IssueAssert hasFileName(String fileName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fileName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualFileName = ((Issue)this.actual).getFileName();
        if (!Objects.deepEquals(actualFileName, fileName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fileName, actualFileName});
        }
        return this;
    }

    public IssueAssert hasFileName() {
        this.isNotNull();
        if (!((Issue)this.actual).hasFileName()) {
            this.failWithMessage("\nExpecting that actual Issue has file name but does not have.", new Object[0]);
        }
        return this;
    }

    public IssueAssert doesNotHaveFileName() {
        this.isNotNull();
        if (((Issue)this.actual).hasFileName()) {
            this.failWithMessage("\nExpecting that actual Issue does not have file name but has.", new Object[0]);
        }
        return this;
    }

    public IssueAssert hasFingerprint(String fingerprint) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting fingerprint of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualFingerprint = ((Issue)this.actual).getFingerprint();
        if (!Objects.deepEquals(actualFingerprint, fingerprint)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, fingerprint, actualFingerprint});
        }
        return this;
    }

    public IssueAssert hasFingerprint() {
        this.isNotNull();
        if (!((Issue)this.actual).hasFingerprint()) {
            this.failWithMessage("\nExpecting that actual Issue has fingerprint but does not have.", new Object[0]);
        }
        return this;
    }

    public IssueAssert doesNotHaveFingerprint() {
        this.isNotNull();
        if (((Issue)this.actual).hasFingerprint()) {
            this.failWithMessage("\nExpecting that actual Issue does not have fingerprint but has.", new Object[0]);
        }
        return this;
    }

    public IssueAssert hasFolder(String folder) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting folder of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualFolder = ((Issue)this.actual).getFolder();
        if (!Objects.deepEquals(actualFolder, folder)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, folder, actualFolder});
        }
        return this;
    }

    public IssueAssert hasId(UUID id) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        UUID actualId = ((Issue)this.actual).getId();
        if (!Objects.deepEquals(actualId, id)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, id, actualId});
        }
        return this;
    }

    public IssueAssert hasLineEnd(int lineEnd) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lineEnd of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualLineEnd = ((Issue)this.actual).getLineEnd();
        if (actualLineEnd != lineEnd) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lineEnd, actualLineEnd});
        }
        return this;
    }

    public IssueAssert hasLineRanges(LineRange ... lineRanges) {
        this.isNotNull();
        if (lineRanges == null) {
            this.failWithMessage("Expecting lineRanges parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((Issue)this.actual).getLineRanges(), (Object[])lineRanges);
        return this;
    }

    public IssueAssert hasLineRanges(Collection<? extends LineRange> lineRanges) {
        this.isNotNull();
        if (lineRanges == null) {
            this.failWithMessage("Expecting lineRanges parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((Issue)this.actual).getLineRanges(), lineRanges.toArray());
        return this;
    }

    public IssueAssert hasOnlyLineRanges(LineRange ... lineRanges) {
        this.isNotNull();
        if (lineRanges == null) {
            this.failWithMessage("Expecting lineRanges parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((Issue)this.actual).getLineRanges(), (Object[])lineRanges);
        return this;
    }

    public IssueAssert hasOnlyLineRanges(Collection<? extends LineRange> lineRanges) {
        this.isNotNull();
        if (lineRanges == null) {
            this.failWithMessage("Expecting lineRanges parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((Issue)this.actual).getLineRanges(), lineRanges.toArray());
        return this;
    }

    public IssueAssert doesNotHaveLineRanges(LineRange ... lineRanges) {
        this.isNotNull();
        if (lineRanges == null) {
            this.failWithMessage("Expecting lineRanges parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((Issue)this.actual).getLineRanges(), (Object[])lineRanges);
        return this;
    }

    public IssueAssert doesNotHaveLineRanges(Collection<? extends LineRange> lineRanges) {
        this.isNotNull();
        if (lineRanges == null) {
            this.failWithMessage("Expecting lineRanges parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((Issue)this.actual).getLineRanges(), lineRanges.toArray());
        return this;
    }

    public IssueAssert hasNoLineRanges() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have lineRanges but had :\n  <%s>";
        if (((Issue)this.actual).getLineRanges().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Issue)this.actual).getLineRanges()});
        }
        return this;
    }

    public IssueAssert hasLineStart(int lineStart) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lineStart of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualLineStart = ((Issue)this.actual).getLineStart();
        if (actualLineStart != lineStart) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lineStart, actualLineStart});
        }
        return this;
    }

    public IssueAssert hasMessage(String message) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualMessage = ((Issue)this.actual).getMessage();
        if (!Objects.deepEquals(actualMessage, message)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, message, actualMessage});
        }
        return this;
    }

    public IssueAssert hasModuleName(String moduleName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting moduleName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualModuleName = ((Issue)this.actual).getModuleName();
        if (!Objects.deepEquals(actualModuleName, moduleName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, moduleName, actualModuleName});
        }
        return this;
    }

    public IssueAssert hasModuleName() {
        this.isNotNull();
        if (!((Issue)this.actual).hasModuleName()) {
            this.failWithMessage("\nExpecting that actual Issue has module name but does not have.", new Object[0]);
        }
        return this;
    }

    public IssueAssert doesNotHaveModuleName() {
        this.isNotNull();
        if (((Issue)this.actual).hasModuleName()) {
            this.failWithMessage("\nExpecting that actual Issue does not have module name but has.", new Object[0]);
        }
        return this;
    }

    public IssueAssert hasOrigin(String origin) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting origin of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualOrigin = ((Issue)this.actual).getOrigin();
        if (!Objects.deepEquals(actualOrigin, origin)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, origin, actualOrigin});
        }
        return this;
    }

    public IssueAssert hasOriginName(String originName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting originName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualOriginName = ((Issue)this.actual).getOriginName();
        if (!Objects.deepEquals(actualOriginName, originName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, originName, actualOriginName});
        }
        return this;
    }

    public IssueAssert hasPackageName(String packageName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting packageName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPackageName = ((Issue)this.actual).getPackageName();
        if (!Objects.deepEquals(actualPackageName, packageName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, packageName, actualPackageName});
        }
        return this;
    }

    public IssueAssert hasPackageName() {
        this.isNotNull();
        if (!((Issue)this.actual).hasPackageName()) {
            this.failWithMessage("\nExpecting that actual Issue has package name but does not have.", new Object[0]);
        }
        return this;
    }

    public IssueAssert doesNotHavePackageName() {
        this.isNotNull();
        if (((Issue)this.actual).hasPackageName()) {
            this.failWithMessage("\nExpecting that actual Issue does not have package name but has.", new Object[0]);
        }
        return this;
    }

    public IssueAssert hasPath(String path) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting path of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPath = ((Issue)this.actual).getPath();
        if (!Objects.deepEquals(actualPath, path)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, path, actualPath});
        }
        return this;
    }

    public IssueAssert hasReference(String reference) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting reference of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualReference = ((Issue)this.actual).getReference();
        if (!Objects.deepEquals(actualReference, reference)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, reference, actualReference});
        }
        return this;
    }

    public IssueAssert hasSeverity(Severity severity) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting severity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Severity actualSeverity = ((Issue)this.actual).getSeverity();
        if (!Objects.deepEquals(actualSeverity, severity)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, severity, actualSeverity});
        }
        return this;
    }

    public IssueAssert hasType(String type) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualType = ((Issue)this.actual).getType();
        if (!Objects.deepEquals(actualType, type)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, type, actualType});
        }
        return this;
    }
}

