/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.pbe;

import edu.vt.middleware.crypt.pbe.AbstractEncryptionScheme;
import edu.vt.middleware.crypt.pbe.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractVariableKeySizeEncryptionScheme
extends AbstractEncryptionScheme {
    private KeyGenerator generator;
    private int keyLength;

    protected void setKeyLength(int l) {
        if (l < 1) {
            throw new IllegalArgumentException("Derived key length must be positive integer.");
        }
        this.keyLength = l;
    }

    protected void setGenerator(KeyGenerator keyGen) {
        if (keyGen == null) {
            throw new IllegalArgumentException("Key generator cannot be null.");
        }
        this.generator = keyGen;
    }

    protected void initCipher(char[] password) {
        byte[] key = this.generator.generate(password, this.keyLength);
        this.cipher.setKey(new SecretKeySpec(key, this.cipher.getAlgorithm()));
        if ("CBC".equals(this.cipher.getMode()) && !this.cipher.hasIV()) {
            this.cipher.setIV(this.generator.generate(password, this.cipher.getBlockSize() * 8));
        }
    }
}

