/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.signature;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.digest.DigestAlgorithm;
import edu.vt.middleware.crypt.digest.SHA1;
import edu.vt.middleware.crypt.signature.SignatureAlgorithm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSASigner;

public class DSASignature
extends SignatureAlgorithm {
    private static final String ALGORITHM = "DSA";
    private final DSASigner signer = new DSASigner();

    public DSASignature() {
        this(new SHA1());
    }

    public DSASignature(DigestAlgorithm d) {
        super(ALGORITHM);
        this.digest = d;
    }

    public void setSignKey(PrivateKey key) {
        if (!DSAPrivateKey.class.isInstance(key)) {
            throw new IllegalArgumentException("DSA private key required.");
        }
        super.setSignKey(key);
    }

    public void setVerifyKey(PublicKey key) {
        if (!DSAPublicKey.class.isInstance(key)) {
            throw new IllegalArgumentException("DSA public key required.");
        }
        super.setVerifyKey(key);
    }

    public void initSign() {
        if (this.signKey == null) {
            throw new IllegalStateException("Sign key must be set prior to initialization.");
        }
        DSAPrivateKey privKey = (DSAPrivateKey)this.signKey;
        DSAParams params = privKey.getParams();
        DSAPrivateKeyParameters bcParams = new DSAPrivateKeyParameters(privKey.getX(), new DSAParameters(params.getP(), params.getQ(), params.getG()));
        this.init(true, (CipherParameters)bcParams);
    }

    public void initVerify() {
        if (this.verifyKey == null) {
            throw new IllegalStateException("Verify key must be set prior to initialization.");
        }
        DSAPublicKey pubKey = (DSAPublicKey)this.verifyKey;
        DSAParams params = pubKey.getParams();
        DSAPublicKeyParameters bcParams = new DSAPublicKeyParameters(pubKey.getY(), new DSAParameters(params.getP(), params.getQ(), params.getG()));
        this.init(false, (CipherParameters)bcParams);
    }

    public byte[] sign(byte[] data) throws CryptException {
        BigInteger[] out = this.signer.generateSignature(this.digest.digest(data));
        return this.encode(out[0], out[1]);
    }

    public byte[] sign(InputStream in) throws CryptException, IOException {
        BigInteger[] out = this.signer.generateSignature(this.digest.digest(in));
        return this.encode(out[0], out[1]);
    }

    public boolean verify(byte[] data, byte[] signature) throws CryptException {
        BigInteger[] sig = this.decode(signature);
        return this.signer.verifySignature(this.digest.digest(data), sig[0], sig[1]);
    }

    public boolean verify(InputStream in, byte[] signature) throws CryptException, IOException {
        BigInteger[] sig = this.decode(signature);
        return this.signer.verifySignature(this.digest.digest(in), sig[0], sig[1]);
    }

    protected void init(boolean forSigning, CipherParameters params) {
        if (forSigning && this.randomProvider != null) {
            this.signer.init(forSigning, (CipherParameters)new ParametersWithRandom(params, this.randomProvider));
        } else {
            this.signer.init(forSigning, params);
        }
    }

    protected byte[] encode(BigInteger r, BigInteger s) throws CryptException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)new DERInteger(r));
        v.add((DEREncodable)new DERInteger(s));
        try {
            new DEROutputStream((OutputStream)out).writeObject((Object)new DERSequence((DEREncodableVector)v));
        }
        catch (IOException e) {
            throw new CryptException("Error encoding DSA signature.", e);
        }
        return out.toByteArray();
    }

    protected BigInteger[] decode(byte[] in) throws CryptException {
        ASN1Sequence s;
        try {
            s = (ASN1Sequence)new ASN1InputStream(in).readObject();
        }
        catch (IOException e) {
            throw new CryptException("Error decoding DSA signature.", e);
        }
        return new BigInteger[]{((DERInteger)s.getObjectAt(0)).getValue(), ((DERInteger)s.getObjectAt(1)).getValue()};
    }
}

