/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

import edu.vt.middleware.crypt.x509.types.AttributeType;
import java.util.HashSet;
import java.util.Set;

public class AttributeTypeAndValue {
    public static final Set<Character> ESCAPE_CHARSET = new HashSet<Character>();
    public static final char ESCAPE_CHAR = '\\';
    private static final int HASH_FACTOR = 31;
    private String type;
    private String value;

    public AttributeTypeAndValue(String typeOid, String attributeValue) {
        this.type = typeOid;
        this.value = attributeValue;
    }

    public AttributeTypeAndValue(AttributeType attributeType, String attributeValue) {
        this(attributeType.getOid(), attributeValue);
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder(70);
        try {
            sb.append(AttributeType.fromOid(this.type).getName());
        }
        catch (IllegalArgumentException e) {
            sb.append(this.type);
        }
        sb.append('=');
        if ('#' == this.value.charAt(0) || ' ' == this.value.charAt(0) || ESCAPE_CHARSET.contains(Character.valueOf(this.value.charAt(0)))) {
            sb.append('\\');
        }
        sb.append(this.value.charAt(0));
        for (i = 1; i < this.value.length() - 1; ++i) {
            if (ESCAPE_CHARSET.contains(Character.valueOf(this.value.charAt(i)))) {
                sb.append('\\');
            }
            sb.append(this.value.charAt(i));
        }
        if (' ' == this.value.charAt(i) || ESCAPE_CHARSET.contains(Character.valueOf(this.value.charAt(i)))) {
            sb.append('\\');
        }
        sb.append(this.value.charAt(i));
        return sb.toString();
    }

    public boolean equals(Object obj) {
        AttributeTypeAndValue other;
        boolean result = false;
        result = obj == this ? true : (obj == null || obj.getClass() != this.getClass() ? false : this.type.equals((other = (AttributeTypeAndValue)obj).getType()) && this.value.equals(other.getValue()));
        return result;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = 31 * hash + this.type.hashCode();
        hash = 31 * hash + this.value.hashCode();
        return hash;
    }

    static {
        ESCAPE_CHARSET.add(Character.valueOf(','));
        ESCAPE_CHARSET.add(Character.valueOf('+'));
        ESCAPE_CHARSET.add(Character.valueOf('\"'));
        ESCAPE_CHARSET.add(Character.valueOf('\\'));
        ESCAPE_CHARSET.add(Character.valueOf('<'));
        ESCAPE_CHARSET.add(Character.valueOf('>'));
        ESCAPE_CHARSET.add(Character.valueOf(';'));
    }
}

