/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

import edu.vt.middleware.crypt.x509.types.BitString;
import edu.vt.middleware.crypt.x509.types.KeyUsageBits;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyUsage
extends BitString {
    public KeyUsage(byte[] bitString) {
        if (bitString == null) {
            throw new IllegalArgumentException("Bit string cannot be null.");
        }
        if (bitString.length < 1 || bitString.length > 2) {
            throw new IllegalArgumentException("Key usage must be 1 or 2 bytes long.");
        }
        this.octets = bitString;
    }

    public KeyUsage(int flags) {
        this.octets = KeyUsage.getBytes(flags);
    }

    public KeyUsage(KeyUsageBits[] bits) {
        int flags = 0;
        for (KeyUsageBits bit : bits) {
            flags |= bit.getMask();
        }
        this.octets = KeyUsage.getBytes(flags);
    }

    public Collection<KeyUsageBits> getUses() {
        ArrayList<KeyUsageBits> bits = new ArrayList<KeyUsageBits>(KeyUsageBits.values().length);
        int intValue = this.intValue();
        for (KeyUsageBits bit : KeyUsageBits.values()) {
            if ((bit.getMask() & intValue) == 0) continue;
            bits.add(bit);
        }
        return bits;
    }

    public String toString() {
        return this.getUses().toString();
    }
}

