/*
 * Decompiled with CFR 0.152.
 */
package fabric.beta.publisher;

import fabric.beta.publisher.FabricService;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Retrofit;

class FabricApi {
    private static FabricService service;

    FabricApi() {
    }

    static FabricService service(PrintStream logger) {
        if (service == null) {
            service = (FabricService)FabricApi.retrofit(logger).create(FabricService.class);
        }
        return service;
    }

    private static Retrofit retrofit(PrintStream logger) {
        return new Retrofit.Builder().baseUrl("https://ssl-download-crashlytics-com.s3.amazonaws.com/").client(FabricApi.client(logger)).build();
    }

    private static OkHttpClient client(PrintStream logger) {
        return new OkHttpClient.Builder().addNetworkInterceptor((Interceptor)FabricApi.interceptor(logger)).readTimeout(60L, TimeUnit.SECONDS).connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).build();
    }

    private static HttpLoggingInterceptor interceptor(final PrintStream logger) {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

            public void log(String s) {
                logger.println(s);
            }
        });
        interceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
        return interceptor;
    }
}

