/*
 * Decompiled with CFR 0.152.
 */
package fabric.beta.publisher;

import fabric.beta.publisher.FabricApi;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import okhttp3.ResponseBody;
import org.springframework.util.FileCopyUtils;
import retrofit2.Response;

class FileUtils {
    FileUtils() {
    }

    static File getManifestFile() throws IOException, InterruptedException {
        File manifestFile = File.createTempFile("xml", null);
        Files.write(manifestFile.toPath(), "<?xml version=\"1.0\" encoding=\"utf-8\"?><manifest></manifest>".getBytes("UTF-8"), new OpenOption[0]);
        return manifestFile;
    }

    static File createTemporaryUploadFile(InputStream inputStream) throws IOException {
        File file = File.createTempFile("app-build-tmp", "apk");
        FileOutputStream outputStream = new FileOutputStream(file);
        FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        outputStream.close();
        return file;
    }

    static File downloadCrashlyticsTools(PrintStream logger) throws IOException, InterruptedException {
        File crashlyticsZip = File.createTempFile("crashlytics", ".zip");
        Response response = FabricApi.service(logger).crashlyticsTools().execute();
        FileUtils.writeResponseBodyToDisk(crashlyticsZip, (ResponseBody)response.body());
        return crashlyticsZip;
    }

    static File extractCrashlyticsJar(File crashlyticsZip, PrintStream logger) throws IOException {
        File crashlyticsJar = FileUtils.createTempDirectory();
        FileUtils.unzip(crashlyticsZip.getAbsolutePath(), crashlyticsJar);
        File crashlyticsZipFile = new File(crashlyticsJar, "crashlytics-devtools.jar");
        FileUtils.delete(logger, crashlyticsZip);
        return crashlyticsZipFile;
    }

    static void delete(PrintStream logger, File ... files) {
        for (File file : files) {
            logger.println("Temporary " + file.getName() + " got deleted = " + file.delete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unzip(String zipFilePath, File destDir) throws IOException {
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            byte[] buffer = new byte[1024];
            fis = new FileInputStream(zipFilePath);
            zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(destDir, fileName);
                File parentFile = new File(newFile.getParent());
                boolean folderCreated = parentFile.mkdirs();
                try (FileOutputStream fos = new FileOutputStream(newFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
        }
        finally {
            if (zis != null) {
                zis.closeEntry();
                zis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    private static void writeResponseBodyToDisk(File target, ResponseBody body) throws IOException, InterruptedException {
        byte[] fileReader = new byte[4096];
        InputStream inputStream = body.byteStream();
        try (FileOutputStream outputStream = new FileOutputStream(target);){
            int read;
            while ((read = inputStream.read(fileReader)) != -1) {
                ((OutputStream)outputStream).write(fileReader, 0, read);
            }
            outputStream.flush();
        }
    }
}

