/*
 * Decompiled with CFR 0.152.
 */
package fabric.beta.publisher;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.scm.ChangeLogSet;
import java.io.IOException;

class ReleaseNotesFormatter {
    ReleaseNotesFormatter() {
    }

    static String getReleaseNotes(ChangeLogSet<? extends ChangeLogSet.Entry> changeLogSet, String releaseNotesType, String releaseNotesParameter, String releaseNotesFile, EnvVars environment, FilePath workspace) throws IOException, InterruptedException {
        switch (releaseNotesType) {
            case "RELEASE_NOTES_NONE": {
                return null;
            }
            case "RELEASE_NOTES_PARAMETER": {
                return environment.get(releaseNotesParameter, "");
            }
            case "RELEASE_NOTES_FROM_CHANGELOG": {
                StringBuilder sb = new StringBuilder();
                if (!changeLogSet.isEmptySet()) {
                    boolean hasManyChangeSets = changeLogSet.getItems().length > 1;
                    for (ChangeLogSet.Entry entry : changeLogSet) {
                        sb.append("\n");
                        if (hasManyChangeSets) {
                            sb.append("* ");
                        }
                        sb.append(entry.getMsg());
                    }
                }
                return sb.toString();
            }
            case "RELEASE_NOTES_FILE": {
                FilePath releaseNotesFilePath = new FilePath(workspace, environment.expand(releaseNotesFile));
                return releaseNotesFilePath.readToString();
            }
        }
        return null;
    }
}

