/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOCoSigner;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.cades.CAdESParameters;
import es.gob.afirma.signers.multi.cades.CAdESCoSigner;
import es.gob.afirma.signers.multi.cades.CAdESMultiUtil;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOCAdESCoSigner
implements AOCoSigner {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        return this.cosign(null, byArray, string, privateKey, certificateArray, properties);
    }

    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        CAdESMultiUtil.checkUnsupportedAttributes(byArray2);
        Properties properties2 = AOCAdESCoSigner.getExtraParams(properties);
        AOCAdESCoSigner.noticeIncompatibleConfig(string, properties2);
        CAdESParameters cAdESParameters = CAdESParameters.load((byte[])byArray, (String)string, (Properties)properties2);
        try {
            return CAdESCoSigner.coSigner(byArray2, string, privateKey, certificateArray, cAdESParameters);
        }
        catch (Exception exception) {
            throw new AOException("Error generando la Cofirma CAdES: " + exception, (Throwable)exception);
        }
    }

    private static Properties getExtraParams(Properties properties) {
        Properties properties2 = properties != null ? (Properties)properties.clone() : new Properties();
        return properties2;
    }

    private static void noticeIncompatibleConfig(String string, Properties properties) {
        if (properties.containsKey("precalculatedHashAlgorithm")) {
            LOGGER.warning("Se ignorara el parametro 'mode' por haberse proporcionado tambien el parametro 'precalculatedHashAlgorithm'. La firma sera explicita.");
            properties.remove("mode");
        }
        if (string != null && AOSignConstants.isSHA2SignatureAlgorithm((String)string) && properties.containsKey("signingCertificateV2")) {
            LOGGER.warning("Se ignorara la propiedad 'signingCertificateV2' porque las firmas SHA2 siempre usan SigningCertificateV2");
            properties.remove("signingCertificateV2");
        }
    }
}

