/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOCounterSigner;
import es.gob.afirma.core.signers.AOSimpleSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.cades.CAdESParameters;
import es.gob.afirma.signers.multi.cades.CAdESCounterSigner;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;

public class AOCAdESCounterSigner
implements AOCounterSigner {
    private final AOSimpleSigner ss;
    private final Date date;
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    public AOCAdESCounterSigner() {
        this.ss = null;
        this.date = null;
    }

    public AOCAdESCounterSigner(AOSimpleSigner aOSimpleSigner, Date date) {
        if (aOSimpleSigner == null) {
            throw new IllegalArgumentException("El firmador PKCS#1 no puede ser nulo");
        }
        if (date == null) {
            LOGGER.warning("Se ha establecido una fecha nula, se usara la actual");
        }
        this.ss = aOSimpleSigner;
        this.date = date;
    }

    public final byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        Properties properties2 = AOCAdESCounterSigner.getExtraParams(properties);
        CAdESParameters cAdESParameters = CAdESParameters.load(null, (String)string, (Properties)properties2);
        if (this.date != null) {
            cAdESParameters.setSigningTime(this.date);
        }
        CAdESCounterSigner cAdESCounterSigner = new CAdESCounterSigner(this.ss);
        if (counterSignTarget == CounterSignTarget.NODES || counterSignTarget == CounterSignTarget.SIGNERS) {
            throw new AOException("No se soporta la firma de nodos individuales");
        }
        byte[] byArray2 = null;
        try {
            byArray2 = cAdESCounterSigner.counterSign(string, byArray, counterSignTarget != null ? counterSignTarget : CounterSignTarget.LEAFS, privateKey, certificateArray, cAdESParameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOException("Algoritmo de firma o huella digital no soportado", (Throwable)noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new AOException("Error generando la Contrafirma CAdES", (Throwable)certificateException);
        }
        return byArray2;
    }

    private static Properties getExtraParams(Properties properties) {
        Properties properties2 = properties != null ? (Properties)properties.clone() : new Properties();
        return properties2;
    }
}

