/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.multi.cades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.AOPkcs1Signer;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.cades.CAdESParameters;
import es.gob.afirma.signers.cades.CAdESUtils;
import es.gob.afirma.signers.multi.cades.CAdESMultiUtil;
import es.gob.afirma.signers.pkcs7.AOAlgorithmID;
import es.gob.afirma.signers.pkcs7.ContainsNoDataException;
import es.gob.afirma.signers.pkcs7.SigUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.BEROctetString;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.cms.CMSAttributes;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.cms.IssuerAndSerialNumber;
import org.spongycastle.asn1.cms.SignedData;
import org.spongycastle.asn1.cms.SignerIdentifier;
import org.spongycastle.asn1.cms.SignerInfo;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x509.AlgorithmIdentifier;
import org.spongycastle.asn1.x509.TBSCertificate;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSProcessableByteArray;

final class CAdESCoSigner {
    CAdESCoSigner() {
    }

    static byte[] coSigner(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, CAdESParameters cAdESParameters) throws IOException, NoSuchAlgorithmException, CertificateException, ContainsNoDataException {
        SignerInfo signerInfo;
        CMSProcessableByteArray cMSProcessableByteArray;
        Object object;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        SignedData signedData = CAdESCoSigner.readData(byArray);
        ContentInfo contentInfo = null;
        if (cAdESParameters.getContentData() != null) {
            aSN1ObjectIdentifier = new ASN1ObjectIdentifier(PKCSObjectIdentifiers.data.getId());
            object = new ByteArrayOutputStream();
            cMSProcessableByteArray = new CMSProcessableByteArray(cAdESParameters.getContentData());
            try {
                cMSProcessableByteArray.write((OutputStream)object);
            }
            catch (CMSException cMSException) {
                throw new IOException("Error en la escritura del procesable CMS: " + (Object)((Object)cMSException), cMSException);
            }
            contentInfo = new ContentInfo(aSN1ObjectIdentifier, (ASN1Encodable)new BEROctetString(((ByteArrayOutputStream)object).toByteArray()));
        } else {
            contentInfo = signedData.getEncapContentInfo();
            if (cAdESParameters.getDataDigest() == null && (aSN1ObjectIdentifier = (DEROctetString)contentInfo.getContent()) != null) {
                object = AOUtil.getDataFromInputStream((InputStream)aSN1ObjectIdentifier.getOctetStream());
                cAdESParameters.setDataDigest(MessageDigest.getInstance(cAdESParameters.getDigestAlgorithm()).digest((byte[])object));
            }
        }
        aSN1ObjectIdentifier = CAdESMultiUtil.addCertificates(signedData, certificateArray);
        object = AOSignConstants.getDigestAlgorithmName((String)string);
        cMSProcessableByteArray = SigUtils.makeAlgId((String)AOAlgorithmID.getOID((String)object));
        TBSCertificate tBSCertificate = TBSCertificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])((X509Certificate)certificateArray[0]).getTBSCertificate()));
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(X500Name.getInstance((Object)tBSCertificate.getIssuer()), tBSCertificate.getSerialNumber().getValue());
        SignerIdentifier signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
        AlgorithmIdentifier algorithmIdentifier = SigUtils.makeAlgId((String)AOAlgorithmID.getOID((String)"RSA"));
        ASN1Set aSN1Set = signedData.getSignerInfos();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i = 0; i < aSN1Set.size(); ++i) {
            AlgorithmIdentifier algorithmIdentifier2;
            signerInfo = SignerInfo.getInstance((Object)aSN1Set.getObjectAt(i));
            aSN1EncodableVector.add((ASN1Encodable)signerInfo);
            if (cAdESParameters.getDataDigest() != null || !(algorithmIdentifier2 = signerInfo.getDigestAlgorithm()).getAlgorithm().toString().equals(AOAlgorithmID.getOID((String)object))) continue;
            ASN1Set aSN1Set2 = signerInfo.getAuthenticatedAttributes();
            for (int j = 0; j < aSN1Set2.size(); ++j) {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Set2.getObjectAt(j);
                ASN1ObjectIdentifier aSN1ObjectIdentifier2 = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0);
                if (!CMSAttributes.messageDigest.getId().equals(aSN1ObjectIdentifier2.toString())) continue;
                DERSet dERSet = (DERSet)aSN1Sequence.getObjectAt(1);
                DEROctetString dEROctetString = (DEROctetString)dERSet.getObjectAt(0);
                cAdESParameters.setDataDigest(dEROctetString.getOctets());
            }
        }
        if (cAdESParameters.getDataDigest() == null && cAdESParameters.getContentData() == null) {
            throw new ContainsNoDataException("No se puede crear la cofirma ya que no se han encontrado ni los datos firmados ni una huella digital compatible con el algoritmo de firma");
        }
        signerInfo = CAdESUtils.generateSignedAttributes((Certificate)certificateArray[0], (CAdESParameters)cAdESParameters, (boolean)false);
        ASN1Set aSN1Set3 = SigUtils.getAttributeSet((AttributeTable)new AttributeTable((ASN1EncodableVector)signerInfo));
        try {
            signerInfo = CAdESCoSigner.generateSignValue(aSN1Set3, string, privateKey, certificateArray, cAdESParameters.getExtraParams());
        }
        catch (AOException aOException) {
            throw new IOException("Error al realizar la firma: " + (Object)((Object)aOException), aOException);
        }
        aSN1EncodableVector.add((ASN1Encodable)new SignerInfo(signerIdentifier, (AlgorithmIdentifier)cMSProcessableByteArray, aSN1Set3, algorithmIdentifier, (ASN1OctetString)signerInfo, null));
        return new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)new SignedData(signedData.getDigestAlgorithms(), contentInfo, (ASN1Set)aSN1ObjectIdentifier, null, (ASN1Set)new DERSet(aSN1EncodableVector))).getEncoded("DER");
    }

    private static SignedData readData(byte[] byArray) throws IOException {
        ASN1Sequence aSN1Sequence;
        try (Object object = new ASN1InputStream(byArray);){
            aSN1Sequence = (ASN1Sequence)object.readObject();
        }
        object = aSN1Sequence.getObjects();
        object.nextElement();
        var3_2 = (ASN1TaggedObject)object.nextElement();
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)var3_2.getObject();
        return SignedData.getInstance((Object)aSN1Sequence2);
    }

    private static ASN1OctetString generateSignValue(ASN1Set aSN1Set, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        byte[] byArray;
        try {
            byArray = aSN1Set.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new AOException("Error al obtener los datos a firmar", (Throwable)iOException);
        }
        return new DEROctetString(new AOPkcs1Signer().sign(byArray, string, privateKey, certificateArray, properties));
    }
}

