/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.AOInvalidFormatException;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.AdESPolicy;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import es.gob.afirma.signers.xades.AOXAdESSigner;
import es.gob.afirma.signers.xades.EFacturaAlreadySignedException;
import es.gob.afirma.signers.xades.InvalidEFacturaDataException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class AOFacturaESigner
implements AOSigner {
    private static final AdESPolicy POLICY_FACTURAE_31 = new AdESPolicy("http://www.facturae.es/politica_de_firma_formato_facturae/politica_de_firma_formato_facturae_v3_1.pdf", "Ohixl6upD6av8N7pEvDABhEL6hM=", "SHA1", null);
    private static final AdESPolicy POLICY_FACTURAE_30 = new AdESPolicy("http://www.facturae.es/politica de firma formato facturae/politica de firma formato facturae v3_0.pdf", "xmfh8D/Ec/hHeE1IB4zPd61zHIY=", "SHA1", null);
    private static final AOSigner XADES_SIGNER = new AOXAdESSigner();
    private static final Set<String> ALLOWED_PARAMS = new HashSet<String>(5);
    private static final Properties EXTRA_PARAMS;
    private static final Logger LOGGER;

    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException, IOException {
        if (!this.isValidDataFile(byArray)) {
            throw new InvalidEFacturaDataException();
        }
        if (this.isSign(byArray)) {
            throw new EFacturaAlreadySignedException();
        }
        return XADES_SIGNER.sign(byArray, string, privateKey, certificateArray, AOFacturaESigner.getFacturaEExtraParams(properties));
    }

    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se soporta la cofirma de facturas");
    }

    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se soporta la cofirma de facturas");
    }

    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se soporta la contrafirma de facturas");
    }

    public static Properties getFacturaEExtraParams(Properties properties) {
        Properties properties2 = (Properties)EXTRA_PARAMS.clone();
        if (properties != null) {
            String string = properties.getProperty("signerClaimedRoles", "emisor").toLowerCase();
            if (!("emisor".equals(string) || "receptor".equals(string) || "tercero".equals(string) || "supplier".equals(string) || "customer".equals(string) || "hird party".equals(string))) {
                throw new IllegalArgumentException("El papel '" + string + "' no es valido para una factura electronica");
            }
            properties.put("signerClaimedRoles", string);
            String string2 = properties.getProperty("policyIdentifier");
            if (string2 != null) {
                AdESPolicy adESPolicy = new AdESPolicy(string2, properties.getProperty("policyIdentifierHash"), properties.getProperty("policyIdentifierHashAlgorithm"), properties.getProperty("policyQualifier"));
                if (!POLICY_FACTURAE_31.equals((Object)adESPolicy) && !POLICY_FACTURAE_30.equals((Object)adESPolicy)) {
                    throw new IllegalArgumentException("La politica no esta soportada (solo se soporta FacturaE 3.0 y 3.1): " + adESPolicy);
                }
            } else {
                properties.remove("policyQualifier");
                properties.putAll((Map<?, ?>)POLICY_FACTURAE_31.asExtraParams());
            }
            for (Object e : properties.keySet()) {
                if (ALLOWED_PARAMS.contains(e)) {
                    properties2.put(e, properties.get(e));
                    continue;
                }
                LOGGER.warning("Se ignorara el siguiente parametro por no estar soportado para la firma de FacturaE: " + e);
            }
        }
        return properties2;
    }

    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) throws AOInvalidFormatException, IOException {
        return XADES_SIGNER.getSignersStructure(byArray, bl);
    }

    public boolean isSign(byte[] byArray) throws IOException {
        return XADES_SIGNER.isSign(byArray) && this.isValidDataFile(byArray);
    }

    public boolean isValidDataFile(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            Element element = document.getDocumentElement();
            String string = element.getPrefix();
            if (!((string != null ? string + ":" : "") + "Facturae").equals(element.getNodeName())) {
                return false;
            }
            HashSet<String> hashSet = new HashSet<String>(3);
            hashSet.add("FileHeader");
            hashSet.add("Parties");
            hashSet.add("Invoices");
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2 = nodeList.item(i).getNodeName();
                if (!hashSet.contains(string2)) continue;
                hashSet.remove(string2);
            }
            if (hashSet.size() > 0) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public String getSignedName(String string, String string2) {
        return XADES_SIGNER.getSignedName(string, string2);
    }

    public byte[] getData(byte[] byArray) throws AOException, IOException {
        return XADES_SIGNER.getData(byArray);
    }

    public AOSignInfo getSignInfo(byte[] byArray) {
        AOSignInfo aOSignInfo = new AOSignInfo("FacturaE");
        aOSignInfo.setVariant(null);
        return aOSignInfo;
    }

    static {
        ALLOWED_PARAMS.add("signatureProductionCity");
        ALLOWED_PARAMS.add("signatureProductionProvince");
        ALLOWED_PARAMS.add("signatureProductionPostalCode");
        ALLOWED_PARAMS.add("signatureProductionCountry");
        ALLOWED_PARAMS.add("xadesNamespace");
        ALLOWED_PARAMS.add("signedPropertiesTypeUrl");
        ALLOWED_PARAMS.add("policyIdentifier");
        ALLOWED_PARAMS.add("policyIdentifierHash");
        ALLOWED_PARAMS.add("policyIdentifierHashAlgorithm");
        ALLOWED_PARAMS.add("policyDescription");
        ALLOWED_PARAMS.add("policyQualifier");
        ALLOWED_PARAMS.add("signerClaimedRoles");
        ALLOWED_PARAMS.add("SignatureId");
        EXTRA_PARAMS = new Properties();
        EXTRA_PARAMS.setProperty("format", "XAdES Enveloped");
        EXTRA_PARAMS.setProperty("mode", "implicit");
        EXTRA_PARAMS.setProperty("facturaeSign", "true");
        LOGGER = Logger.getLogger("es.gob.afirma");
    }
}

