/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.signers.xades.AOXAdESSigner;
import es.gob.afirma.signers.xades.AOXMLAdvancedSignature;
import es.gob.afirma.signers.xades.XAdESCommonMetadataUtil;
import es.gob.afirma.signers.xades.XAdESUtil;
import es.gob.afirma.signers.xml.Utils;
import es.gob.afirma.signers.xml.XMLConstants;
import es.uji.crypto.xades.jxades.security.xml.XAdES.DataObjectFormatImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.ObjectIdentifier;
import es.uji.crypto.xades.jxades.security.xml.XAdES.ObjectIdentifierImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES_EPES;
import java.io.ByteArrayInputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XAdESCounterSigner {
    private static final String CSURI = "http://uri.etsi.org/01903#CountersignedSignature";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    public static byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Element element;
        Map<String, String> map;
        Document document;
        Properties properties2 = properties != null ? properties : new Properties();
        String string2 = properties2.getProperty("outputXmlEncoding");
        if (byArray == null) {
            throw new IllegalArgumentException("El objeto de firma no puede ser nulo");
        }
        String string3 = (String)XMLConstants.SIGN_ALGOS_URI.get(string);
        if (string3 == null) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "'");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        boolean bl = false;
        try {
            document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(byArray));
            map = XAdESUtil.getOriginalXMLProperties(document, string2);
            element = document.getDocumentElement();
            if (element.getNodeName().equals("ds:Signature")) {
                bl = true;
                document = AOXAdESSigner.insertarNodoAfirma(document);
                element = document.getDocumentElement();
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma: " + exception, (Throwable)exception);
        }
        try {
            if (counterSignTarget == CounterSignTarget.TREE) {
                XAdESCounterSigner.countersignTree(element, privateKey, certificateArray, properties2, string, document);
            } else if (counterSignTarget == CounterSignTarget.LEAFS) {
                XAdESCounterSigner.countersignLeafs(element, privateKey, certificateArray, properties2, string, document);
            } else if (counterSignTarget == CounterSignTarget.NODES) {
                XAdESCounterSigner.countersignNodes(element, objectArray, privateKey, certificateArray, properties2, string, document);
            } else if (counterSignTarget == CounterSignTarget.SIGNERS) {
                XAdESCounterSigner.countersignSigners(element, objectArray, privateKey, certificateArray, properties2, string, document);
            }
        }
        catch (Exception exception) {
            throw new AOException("Error al generar la contrafirma", (Throwable)exception);
        }
        if (bl) {
            try {
                Document document2 = documentBuilderFactory.newDocumentBuilder().newDocument();
                document2.appendChild(document2.adoptNode(document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0)));
                document = document2;
            }
            catch (Exception exception) {
                LOGGER.info("No se ha eliminado el nodo padre '<AFIRMA>': " + exception);
            }
        }
        return Utils.writeXML((Node)document.getDocumentElement(), map, null, null);
    }

    private static void countersignLeafs(Element element, PrivateKey privateKey, Certificate[] certificateArray, Properties properties, String string, Document document) throws AOException {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        int n = nodeList.getLength();
        try {
            for (int i = 0; i < n; ++i) {
                Element element2 = (Element)nodeList.item(i);
                int n2 = element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").getLength();
                if (n2 != 0) continue;
                XAdESCounterSigner.cs(element2, privateKey, certificateArray, properties, string, document);
                ++n;
                ++i;
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma de hojas", (Throwable)exception);
        }
    }

    private static void countersignNodes(Element element, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties, String string, Document document) throws AOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (arrayList.contains(objectArray[i])) continue;
            arrayList.add((Integer)objectArray[i]);
        }
        Object[] objectArray2 = arrayList.toArray();
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        Element[] elementArray = new Element[objectArray2.length];
        try {
            for (int i = 0; i < objectArray2.length; ++i) {
                elementArray[i] = (Element)nodeList.item((Integer)objectArray2[i]);
                if (elementArray[i] != null) continue;
                throw new AOException("Posicion de nodo no valida.");
            }
        }
        catch (ClassCastException classCastException) {
            throw new AOException("Valor de nodo no valido", (Throwable)classCastException);
        }
        try {
            for (Element element2 : elementArray) {
                XAdESCounterSigner.cs(element2, privateKey, certificateArray, properties, string, document);
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma de nodos", (Throwable)exception);
        }
    }

    private static void countersignSigners(Element element, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties, String string, Document document) throws AOException {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        List<Object> list = Arrays.asList(objectArray);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (!list.contains(AOUtil.getCN((X509Certificate)Utils.getCertificate((Node)element2.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509Certificate").item(0))))) continue;
            arrayList.add(element2);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            XAdESCounterSigner.cs((Element)iterator.next(), privateKey, certificateArray, properties, string, document);
        }
    }

    private static void countersignTree(Element element, PrivateKey privateKey, Certificate[] certificateArray, Properties properties, String string, Document document) throws AOException {
        int n;
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        int n2 = nodeList.getLength();
        Element[] elementArray = new Element[n2];
        for (n = 0; n < n2; ++n) {
            elementArray[n] = (Element)nodeList.item(n);
        }
        try {
            for (n = 0; n < n2; ++n) {
                XAdESCounterSigner.cs(elementArray[n], privateKey, certificateArray, properties, string, document);
            }
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma del arbol", (Throwable)exception);
        }
    }

    private static void cs(Element element, PrivateKey privateKey, Certificate[] certificateArray, Properties properties, String string, Document document) throws AOException {
        XAdES_EPES xAdES_EPES;
        DigestMethod digestMethod;
        Element element2;
        Element element3;
        String string2 = XAdESUtil.guessXAdESNamespacePrefix(element);
        if (document == null) {
            throw new IllegalArgumentException("El documento DOM no puede ser nulo");
        }
        Properties properties2 = properties != null ? properties : new Properties();
        String string3 = properties2.getProperty("referencesDigestMethod", "http://www.w3.org/2001/04/xmlenc#sha512");
        String string4 = properties2.getProperty("canonicalizationAlgorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        String string5 = properties2.getProperty("xadesNamespace", "http://uri.etsi.org/01903/v1.3.2#");
        String string6 = properties2.getProperty("signedPropertiesTypeUrl", "http://uri.etsi.org/01903#SignedProperties");
        boolean bl = Boolean.parseBoolean(properties2.getProperty("useManifest", Boolean.FALSE.toString()));
        NodeList nodeList = element.getElementsByTagNameNS("*", "UnsignedProperties");
        if (nodeList.getLength() == 0) {
            element3 = document.createElement(XAdESCounterSigner.addNSPrefix(string2, "UnsignedProperties"));
        } else {
            element3 = (Element)nodeList.item(0);
            string2 = element3.getPrefix();
        }
        NodeList nodeList2 = element.getElementsByTagNameNS("*", "UnsignedSignatureProperties");
        if (nodeList2.getLength() == 0) {
            element2 = document.createElement(XAdESCounterSigner.addNSPrefix(string2, "UnsignedSignatureProperties"));
        } else {
            element2 = (Element)nodeList2.item(0);
            string2 = element2.getPrefix();
        }
        Element element4 = document.createElement(XAdESCounterSigner.addNSPrefix(string2, "CounterSignature"));
        element2.appendChild(element4);
        element3.appendChild(element2);
        Node node = element.getElementsByTagNameNS("*", "QualifyingProperties").item(0);
        node.appendChild(element3);
        Element element5 = (Element)element.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue").item(0);
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        XMLSignatureFactory xMLSignatureFactory = Utils.getDOMFactory();
        try {
            digestMethod = xMLSignatureFactory.newDigestMethod(string3, null);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido obtener un generador de huellas digitales para el algoritmo '" + string3 + "'", (Throwable)exception);
        }
        String string7 = "Reference-" + UUID.randomUUID().toString();
        try {
            xAdES_EPES = new ArrayList();
            xAdES_EPES.add(xMLSignatureFactory.newTransform(string4, (TransformParameterSpec)null));
            arrayList.add(xMLSignatureFactory.newReference("#" + element5.getAttribute("Id"), digestMethod, (List<? extends Transform>)xAdES_EPES, CSURI, string7));
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma", (Throwable)exception);
        }
        xAdES_EPES = (XAdES_EPES)XAdES.newInstance((XAdES)XAdES.EPES, (String)string5, (String)string2, (String)"ds", (String)string3, (Document)element4.getOwnerDocument(), (Element)element4);
        X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
        xAdES_EPES.setSigningCertificate(x509Certificate);
        XAdESCommonMetadataUtil.addCommonMetadata(xAdES_EPES, properties2);
        ObjectIdentifierImpl objectIdentifierImpl = new ObjectIdentifierImpl("OIDAsURN", "urn:oid:1.2.840.10003.5.109.10", null, new ArrayList(0));
        DataObjectFormatImpl dataObjectFormatImpl = new DataObjectFormatImpl(null, (ObjectIdentifier)objectIdentifierImpl, "text/xml", document.getInputEncoding(), "#" + string7);
        ArrayList<DataObjectFormatImpl> arrayList2 = new ArrayList<DataObjectFormatImpl>();
        arrayList2.add(dataObjectFormatImpl);
        xAdES_EPES.setDataObjectFormats(arrayList2);
        AOXMLAdvancedSignature aOXMLAdvancedSignature = XAdESUtil.getXmlAdvancedSignature(xAdES_EPES, string6, string3, string4);
        if (bl) {
            try {
                XAdESUtil.createManifest(arrayList, xMLSignatureFactory, aOXMLAdvancedSignature, digestMethod, xMLSignatureFactory.newTransform(string4, (TransformParameterSpec)null), string7);
            }
            catch (Exception exception) {
                throw new AOException("Error creando el algoritmo de canonicalizacion para el MANIFEST: " + exception, (Throwable)exception);
            }
        }
        try {
            boolean bl2 = Boolean.parseBoolean(properties2.getProperty("includeOnlySignningCertificate", Boolean.FALSE.toString()));
            if (bl2) {
                aOXMLAdvancedSignature.sign((X509Certificate)certificateArray[0], privateKey, (String)XMLConstants.SIGN_ALGOS_URI.get(string), arrayList, "Signature-" + UUID.randomUUID().toString());
            } else {
                aOXMLAdvancedSignature.sign(Arrays.asList(certificateArray), privateKey, (String)XMLConstants.SIGN_ALGOS_URI.get(string), arrayList, "Signature-" + UUID.randomUUID().toString(), Boolean.parseBoolean(properties2.getProperty("addKeyInfoKeyValue", Boolean.TRUE.toString())), Boolean.parseBoolean(properties2.getProperty("addKeyInfoKeyName", Boolean.FALSE.toString())), Boolean.parseBoolean(properties2.getProperty("addKeyInfoX509IssuerSerial", Boolean.FALSE.toString())), Boolean.parseBoolean(properties2.getProperty("keepKeyInfoUnsigned", Boolean.FALSE.toString())));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UnsupportedOperationException("Los formatos de firma XML no soportan el algoritmo de firma '" + string + "'", noSuchAlgorithmException);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido realizar la contrafirma", (Throwable)exception);
        }
    }

    private static String addNSPrefix(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return string2;
        }
        return string + ":" + string2;
    }

    private XAdESCounterSigner() {
    }
}

